/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.eclipse;

import java.util.Collection;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="leaking_bundles")
public class LeakingPlugins
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.osgi.framework.internal.core.BundleLoaderProxy", true);
        ArrayInt result = new ArrayInt();
        if (classes != null) {
            for (IClass clazz : classes) {
                int[] nArray = clazz.getObjectIds();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int objectId = nArray[n2];
                    IObject proxy = this.snapshot.getObject(objectId);
                    boolean isStale = (Boolean)proxy.resolveValue("stale");
                    if (isStale) {
                        IClassLoader classLoader = (IClassLoader)proxy.resolveValue("loader.classloader");
                        result.add(classLoader.getObjectId());
                    }
                    ++n2;
                }
            }
        }
        if (result.isEmpty()) {
            return new TextResult(Messages.LeakingPlugins_NoLeakingPlugInsDetected);
        }
        return new ObjectListResult.Inbound(this.snapshot, result.toArray());
    }
}

