/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.osgi.model.Bundle;
import org.eclipse.mat.inspections.osgi.model.BundleDescriptor;
import org.eclipse.mat.inspections.osgi.model.BundleFragment;
import org.eclipse.mat.inspections.osgi.model.BundleReaderFactory;
import org.eclipse.mat.inspections.osgi.model.IBundleReader;
import org.eclipse.mat.inspections.osgi.model.OSGiModel;
import org.eclipse.mat.inspections.osgi.model.Service;
import org.eclipse.mat.inspections.osgi.model.eclipse.ConfigurationElement;
import org.eclipse.mat.inspections.osgi.model.eclipse.Extension;
import org.eclipse.mat.inspections.osgi.model.eclipse.ExtensionPoint;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="bundle_registry")
@Icon(value="/META-INF/icons/osgi/registry.gif")
public class BundleRegistryQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public Grouping groupBy = Grouping.NONE;

    public IResult execute(IProgressListener listener) throws Exception {
        IBundleReader bundleReader = BundleReaderFactory.getBundleReader(this.snapshot);
        OSGiModel model = bundleReader.readOSGiModel(listener);
        return this.create(model);
    }

    private BundleTreeResult create(OSGiModel model) {
        if (this.groupBy == null) {
            this.groupBy = Grouping.NONE;
        }
        switch (this.groupBy) {
            case NONE: {
                return Factory.create(model);
            }
            case BY_SERVICE: {
                return Factory.servicesOnTop(model);
            }
            case BY_EXTENSION_POINT: {
                return Factory.extensionPointsOnTop(model);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleTreeResult
    implements IResultTree,
    IIconProvider {
        protected OSGiModel model;
        protected Grouping topLevelBy;

        public BundleTreeResult(OSGiModel model) {
            this.model = model;
        }

        public OSGiModel getModel() {
            return this.model;
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof BundleDescriptor) {
                Bundle bundle;
                BundleDescriptor descriptor = (BundleDescriptor)parent;
                try {
                    bundle = this.model.getBundle(descriptor);
                }
                catch (SnapshotException e) {
                    MATPlugin.log(e, Messages.BundleRegistryQuery_ErrorMsg_FailedReadingModel);
                    return null;
                }
                ArrayList<Folder> children = new ArrayList<Folder>(2);
                if (bundle.getLocation() != null) {
                    children.add(new Folder(bundle, bundle.getLocation(), Type.LOCATION));
                }
                if (bundle.getDependencies() != null && !bundle.getDependencies().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_Dependencies, Type.DEPENDENCIES));
                }
                if (bundle.getDependents() != null && !bundle.getDependents().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_Dependents, Type.DEPENDENTS));
                }
                if (bundle.getExtentionPoints() != null && !bundle.getExtentionPoints().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_ExtensionPoints, Type.EXTENSION_POINTS));
                }
                if (bundle.getExtentions() != null && !bundle.getExtentions().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_Extensions, Type.EXTENSIONS));
                }
                if (bundle.getRegisteredServices() != null && !bundle.getRegisteredServices().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_RegisteredServices, Type.REGISTERED_SERVICES));
                }
                if (bundle.getUsedServices() != null && !bundle.getUsedServices().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_UserServices, Type.SERVICES_IN_USE));
                }
                if (bundle.getFragments() != null && !bundle.getFragments().isEmpty()) {
                    children.add(new Folder(bundle, Messages.BundleRegistryQuery_Fragments, Type.FRAGMENTS));
                }
                if (bundle instanceof BundleFragment && ((BundleFragment)bundle).getHost() != null) {
                    children.add(new Folder(bundle, MessageUtil.format((String)Messages.BundleRegistryQuery_HostedBy, (Object[])new Object[]{((BundleFragment)bundle).getHost().getBundleName()}), Type.HOST));
                }
                return children;
            }
            if (parent instanceof Folder) {
                Folder folder = (Folder)parent;
                switch (folder.type) {
                    case DEPENDENCIES: {
                        return folder.bundle.getDependencies();
                    }
                    case DEPENDENTS: {
                        return folder.bundle.getDependents();
                    }
                    case EXTENSION_POINTS: {
                        return folder.bundle.getExtentionPoints();
                    }
                    case EXTENSIONS: {
                        return folder.bundle.getExtentions();
                    }
                    case REGISTERED_SERVICES: {
                        return folder.bundle.getRegisteredServices();
                    }
                    case SERVICES_IN_USE: {
                        return folder.bundle.getUsedServices();
                    }
                    case CONTRIBUTED_BY: {
                        return ((ExtensionFolder)folder).extension.getConfigurationElements();
                    }
                    case FRAGMENTS: {
                        return folder.bundle.getFragments();
                    }
                    case HOST: {
                        return this.getChildren(((BundleFragment)folder.bundle).getHost());
                    }
                    case PROPERTIES: {
                        return ((PropertiesFolder)folder).service.getProperties();
                    }
                    case BUNDLES_USING: {
                        return ((PropertiesFolder)folder).service.getBundlesUsing();
                    }
                }
            } else {
                if (parent instanceof ExtensionPoint) {
                    ExtensionPoint point = (ExtensionPoint)parent;
                    List<Extension> extensions = point.getExtensions();
                    ArrayList<ExtensionFolder> children = new ArrayList<ExtensionFolder>(extensions.size());
                    for (Extension extension : extensions) {
                        String bundleName = extension.getContributedBy() != null ? extension.getContributedBy().getBundleName() : "";
                        children.add(new ExtensionFolder(extension, MessageUtil.format((String)Messages.BundleRegistryQuery_ContributedBy, (Object[])new Object[]{bundleName}), Type.CONTRIBUTED_BY));
                    }
                    return children;
                }
                if (parent instanceof Extension) {
                    return ((Extension)parent).getConfigurationElements();
                }
                if (parent instanceof ConfigurationElement) {
                    ArrayList<Object> children = new ArrayList<Object>();
                    children.addAll(((ConfigurationElement)parent).getPropertiesAndValues());
                    List<ConfigurationElement> configElements = ((ConfigurationElement)parent).getConfigurationElements();
                    if (configElements != null) {
                        children.addAll(configElements);
                    }
                    return children;
                }
                if (parent instanceof Service) {
                    Service service = (Service)parent;
                    ArrayList<PropertiesFolder> children = new ArrayList<PropertiesFolder>(2);
                    if (service.getProperties() != null) {
                        children.add(new PropertiesFolder(service, Messages.BundleRegistryQuery_Properties, Type.PROPERTIES));
                    }
                    if (service.getBundlesUsing() != null && !service.getBundlesUsing().isEmpty()) {
                        children.add(new PropertiesFolder(service, Messages.BundleRegistryQuery_BundlesUsing, Type.BUNDLES_USING));
                    }
                    return children;
                }
            }
            return null;
        }

        public List<?> getElements() {
            return this.model.getBundleDescriptors();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BundleDescriptor || element instanceof Extension) {
                return true;
            }
            if (element instanceof ExtensionPoint) {
                return !((ExtensionPoint)element).getExtensions().isEmpty();
            }
            if (element instanceof ConfigurationElement) {
                return !((ConfigurationElement)element).getConfigurationElements().isEmpty() || !((ConfigurationElement)element).getPropertiesAndValues().isEmpty();
            }
            if (element instanceof Service) {
                return ((Service)element).getProperties() != null;
            }
            if (element instanceof Folder) {
                switch (((Folder)element).type) {
                    case LOCATION: {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.BundleRegistryQuery_Bundles), new Column(Messages.BundleRegistryQuery_BundleState).noTotals()};
        }

        public Object getColumnValue(Object row, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (row instanceof BundleDescriptor) {
                        return ((BundleDescriptor)row).getBundleName();
                    }
                    if (row instanceof Folder) {
                        return ((Folder)row).label;
                    }
                    if (row instanceof Service) {
                        return ((Service)row).getName();
                    }
                    if (row instanceof ExtensionPoint) {
                        return ((ExtensionPoint)row).getName();
                    }
                    if (row instanceof Extension) {
                        return ((Extension)row).getName();
                    }
                    if (row instanceof ConfigurationElement) {
                        return ((ConfigurationElement)row).getName();
                    }
                    if (row instanceof ConfigurationElement.PropertyPair) {
                        return String.valueOf(((ConfigurationElement.PropertyPair)row).property) + " = " + ((ConfigurationElement.PropertyPair)row).value;
                    }
                    if (row instanceof Service.ServiceProperty) {
                        return String.valueOf(((Service.ServiceProperty)row).property) + " = " + ((Service.ServiceProperty)row).value;
                    }
                }
                case 1: {
                    if (row instanceof BundleDescriptor) {
                        return ((BundleDescriptor)row).getState();
                    }
                    if (!(row instanceof Folder) || !((Folder)row).type.equals((Object)Type.HOST)) break;
                    return ((BundleFragment)((Folder)row).bundle).getHost().getState();
                }
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            if (row instanceof ExtensionFolder) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((ExtensionFolder)row).extension.getObjectId();
                    }
                };
            }
            if (row instanceof Folder && ((Folder)row).type.equals((Object)Type.HOST)) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((BundleFragment)((Folder)row).bundle).getHost().getObjectId();
                    }
                };
            }
            if (row instanceof DescriptorFolder) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((DescriptorFolder)row).descriptor.getObjectId();
                    }
                };
            }
            if (row instanceof Folder || row instanceof ConfigurationElement.PropertyPair || row instanceof Service.ServiceProperty) {
                return null;
            }
            return new IContextObject(){

                public int getObjectId() {
                    if (row instanceof BundleDescriptor) {
                        return ((BundleDescriptor)row).getObjectId();
                    }
                    if (row instanceof Service) {
                        return ((Service)row).getObjectId();
                    }
                    if (row instanceof ExtensionPoint) {
                        return ((ExtensionPoint)row).getObjectId();
                    }
                    if (row instanceof Extension) {
                        return ((Extension)row).getObjectId();
                    }
                    if (row instanceof ConfigurationElement) {
                        return ((ConfigurationElement)row).getObjectId();
                    }
                    return -1;
                }
            };
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public URL getIcon(Object row) {
            if (row instanceof BundleDescriptor) {
                if (((BundleDescriptor)row).getType().equals((Object)BundleDescriptor.Type.FRAGMENT)) {
                    return Icons.FRAGMENT;
                }
                return Icons.BUNDLE;
            }
            if (row instanceof Folder) {
                switch (((Folder)row).type) {
                    case LOCATION: {
                        return Icons.LOCATION;
                    }
                    case DEPENDENCIES: {
                        return Icons.DEPENDENCIES;
                    }
                    case DEPENDENTS: {
                        return Icons.DEPENDENTS;
                    }
                    case SERVICES_IN_USE: {
                        return Icons.USED_SERVICES;
                    }
                    case REGISTERED_SERVICES: {
                        return Icons.REGISTERED_SERVICES;
                    }
                    case EXTENSION_POINTS: {
                        return Icons.EXTENSION_POINTS;
                    }
                    case EXTENSIONS: {
                        return Icons.EXTENSIONS;
                    }
                    case CONTRIBUTED_BY: {
                        return Icons.EXTENSION;
                    }
                    case FRAGMENTS: {
                        return Icons.FRAGMENTS;
                    }
                    case HOST: {
                        return Icons.BUNDLE;
                    }
                    case BUNDLE: {
                        return Icons.BUNDLE;
                    }
                    case PROPERTIES: {
                        return Icons.PROPERTY;
                    }
                    case BUNDLES_USING: {
                        return Icons.DEPENDENTS;
                    }
                }
            }
            if (row instanceof Service) {
                return Icons.SERVICE;
            }
            if (row instanceof ExtensionPoint) {
                return Icons.EXTENSION_POINT;
            }
            if (row instanceof Extension) {
                return Icons.EXTENSION;
            }
            if (row instanceof ConfigurationElement) {
                return Icons.ATTRIBUTE;
            }
            if (row instanceof ConfigurationElement.PropertyPair) {
                return Icons.PROPERTY_PAIR;
            }
            if (row instanceof Service.ServiceProperty) {
                return Icons.PROPERTY;
            }
            return null;
        }

        public Grouping getGroupBy() {
            return Grouping.NONE;
        }
    }

    private static class DescriptorFolder
    extends Folder {
        BundleDescriptor descriptor;

        public DescriptorFolder(BundleDescriptor descriptor, String label, Type type) {
            super(null, label, type);
            this.descriptor = descriptor;
        }
    }

    private static class ExtensionFolder
    extends Folder {
        Extension extension;

        ExtensionFolder(Extension extension, String label, Type type) {
            super(null, label, type);
            this.extension = extension;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionTreeResult
    extends BundleTreeResult {
        public ExtensionTreeResult(OSGiModel model) {
            super(model);
        }

        @Override
        public List<?> getChildren(Object parent) {
            if (parent instanceof ExtensionPoint) {
                ExtensionPoint point = (ExtensionPoint)parent;
                List<Extension> extensions = point.getExtensions();
                ArrayList<Folder> children = new ArrayList<Folder>(extensions.size());
                for (Extension extension : extensions) {
                    if (extension.getContributedBy() == null) continue;
                    children.add(new ExtensionFolder(extension, MessageUtil.format((String)Messages.BundleRegistryQuery_ContributedBy, (Object[])new Object[]{extension.getContributedBy().getBundleName()}), Type.CONTRIBUTED_BY));
                }
                if (point.getContributedBy() != null) {
                    children.add(new DescriptorFolder(point.getContributedBy(), MessageUtil.format((String)Messages.BundleRegistryQuery_RegisteredBy, (Object[])new Object[]{point.getContributedBy().getBundleName()}), Type.BUNDLE));
                }
                return children;
            }
            if (parent instanceof Folder) {
                Folder folder = (Folder)parent;
                switch (folder.type) {
                    case BUNDLE: {
                        return super.getChildren(((DescriptorFolder)folder).descriptor);
                    }
                }
            }
            return super.getChildren(parent);
        }

        @Override
        public List<?> getElements() {
            return this.model.getExtensionPoints();
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof ExtensionPoint) {
                return ((ExtensionPoint)element).getContributedBy() != null || !((ExtensionPoint)element).getExtensions().isEmpty();
            }
            return super.hasChildren(element);
        }

        @Override
        public Grouping getGroupBy() {
            return Grouping.BY_EXTENSION_POINT;
        }

        @Override
        public Column[] getColumns() {
            return new Column[]{new Column(Messages.BundleRegistryQuery_ExtensionPoints), new Column(Messages.BundleRegistryQuery_BundleState).noTotals()};
        }
    }

    public static class Factory {
        public static BundleTreeResult create(OSGiModel model) {
            return new BundleTreeResult(model);
        }

        public static BundleTreeResult servicesOnTop(OSGiModel model) {
            return new ServicesTreeResult(model);
        }

        public static BundleTreeResult extensionPointsOnTop(OSGiModel model) {
            return new ExtensionTreeResult(model);
        }
    }

    private static class Folder {
        String label;
        Bundle bundle;
        Type type;

        public Folder(Bundle bundle, String label, Type type) {
            this.bundle = bundle;
            this.label = label;
            this.type = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grouping {
        NONE(Messages.BundleRegistryQuery_Bundles, Icons.BUNDLE),
        BY_SERVICE(Messages.BundleRegistryQuery_Services, Icons.SERVICE),
        BY_EXTENSION_POINT(Messages.BundleRegistryQuery_ExtensionPoints, Icons.EXTENSION_POINTS);

        String label;
        URL icon;

        private Grouping(String label, URL icon) {
            this.label = label;
            this.icon = icon;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label;
        }
    }

    static interface Icons {
        public static final URL BUNDLE = BundleTreeResult.class.getResource("/META-INF/icons/osgi/bundle.gif");
        public static final URL LOCATION = BundleTreeResult.class.getResource("/META-INF/icons/osgi/location.gif");
        public static final URL DEPENDENTS = BundleTreeResult.class.getResource("/META-INF/icons/osgi/dependents.gif");
        public static final URL DEPENDENCIES = BundleTreeResult.class.getResource("/META-INF/icons/osgi/dependencies.gif");
        public static final URL USED_SERVICES = BundleTreeResult.class.getResource("/META-INF/icons/osgi/used_services.gif");
        public static final URL REGISTERED_SERVICES = BundleTreeResult.class.getResource("/META-INF/icons/osgi/registered_services.gif");
        public static final URL SERVICE = BundleTreeResult.class.getResource("/META-INF/icons/osgi/int_obj.gif");
        public static final URL EXTENSION_POINTS = BundleTreeResult.class.getResource("/META-INF/icons/osgi/ext_points_obj.gif");
        public static final URL EXTENSION_POINT = BundleTreeResult.class.getResource("/META-INF/icons/osgi/ext_point_obj.gif");
        public static final URL EXTENSIONS = BundleTreeResult.class.getResource("/META-INF/icons/osgi/extensions_obj.gif");
        public static final URL EXTENSION = BundleTreeResult.class.getResource("/META-INF/icons/osgi/extension_obj.gif");
        public static final URL PROPERTY_PAIR = BundleTreeResult.class.getResource("/META-INF/icons/osgi/attr_xml_obj.gif");
        public static final URL ATTRIBUTE = BundleTreeResult.class.getResource("/META-INF/icons/osgi/generic_xml_obj.gif");
        public static final URL FRAGMENTS = BundleTreeResult.class.getResource("/META-INF/icons/osgi/frgmts_obj.gif");
        public static final URL FRAGMENT = BundleTreeResult.class.getResource("/META-INF/icons/osgi/frgmt_obj.gif");
        public static final URL PROPERTY = BundleTreeResult.class.getResource("/META-INF/icons/osgi/property.gif");
    }

    private static class PropertiesFolder
    extends Folder {
        Service service;

        PropertiesFolder(Service service, String label, Type type) {
            super(null, label, type);
            this.service = service;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServicesTreeResult
    extends BundleTreeResult {
        public ServicesTreeResult(OSGiModel model) {
            super(model);
        }

        @Override
        public List<?> getChildren(Object parent) {
            if (parent instanceof Service) {
                Service service = (Service)parent;
                ArrayList<Folder> children = new ArrayList<Folder>(2);
                if (service.getProperties() != null) {
                    children.add(new PropertiesFolder(service, Messages.BundleRegistryQuery_Properties, Type.PROPERTIES));
                }
                children.add(new DescriptorFolder(service.getBundleDescriptor(), MessageUtil.format((String)Messages.BundleRegistryQuery_RegisteredBy, (Object[])new Object[]{service.getBundleDescriptor().getBundleName()}), Type.BUNDLE));
                if (service.getBundlesUsing() != null && !service.getBundlesUsing().isEmpty()) {
                    children.add(new PropertiesFolder(service, Messages.BundleRegistryQuery_BundlesUsing, Type.BUNDLES_USING));
                }
                return children;
            }
            if (parent instanceof Folder) {
                Folder folder = (Folder)parent;
                switch (folder.type) {
                    case BUNDLE: {
                        return super.getChildren(((DescriptorFolder)folder).descriptor);
                    }
                }
            }
            return super.getChildren(parent);
        }

        @Override
        public List<?> getElements() {
            return this.model.getServices();
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof Service) {
                return ((Service)element).getProperties() != null || ((Service)element).getBundleDescriptor() != null;
            }
            return super.hasChildren(element);
        }

        @Override
        public Grouping getGroupBy() {
            return Grouping.BY_SERVICE;
        }

        @Override
        public Column[] getColumns() {
            return new Column[]{new Column(Messages.BundleRegistryQuery_Services), new Column(Messages.BundleRegistryQuery_BundleState).noTotals()};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        LOCATION,
        EXTENSIONS,
        EXTENSION_POINTS,
        DEPENDENCIES,
        DEPENDENTS,
        REGISTERED_SERVICES,
        SERVICES_IN_USE,
        CONTRIBUTED_BY,
        FRAGMENTS,
        HOST,
        PROPERTIES,
        BUNDLES_USING,
        BUNDLE;

    }
}

