/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="thread_stacks")
@Icon(value="/META-INF/icons/threads.gif")
public class ThreadStackQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none", isMandatory=false)
    public IHeapObjectArgument objects;
    private static URL THREAD_ICON_URL = ThreadStackQuery.class.getResource("/META-INF/icons/threads.gif");

    public IResult execute(IProgressListener listener) throws Exception {
        SetInt roots;
        ArrayList<IThreadStack> stacks;
        block3: {
            block2: {
                stacks = new ArrayList<IThreadStack>();
                roots = new SetInt();
                if (this.objects != null) break block2;
                Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.Thread", true);
                if (classes == null) break block3;
                for (IClass clazz : classes) {
                    int[] objectIds = clazz.getObjectIds();
                    this.addThreadStacks(objectIds, stacks, roots);
                }
                break block3;
            }
            for (int[] objectIds : this.objects) {
                this.addThreadStacks(objectIds, stacks, roots);
            }
        }
        return new Result(stacks, roots.toArray());
    }

    private void addThreadStacks(int[] objectIds, List<IThreadStack> stacks, SetInt roots) throws SnapshotException {
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objectId = nArray[n2];
            IThreadStack stack = this.snapshot.getThreadStack(objectId);
            if (stack != null) {
                stacks.add(stack);
                IStackFrame[] frames = stack.getStackFrames();
                if (frames != null) {
                    IStackFrame[] iStackFrameArray = frames;
                    int n3 = frames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IStackFrame IStackFrame2 = iStackFrameArray[n4];
                        int[] objects = IStackFrame2.getLocalObjectsIds();
                        if (objects != null) {
                            int[] nArray2 = objects;
                            int n5 = objects.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                int i = nArray2[n6];
                                roots.add(i);
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Result
    implements IResultTree,
    IIconProvider,
    IDecorator {
        List<IThreadStack> callstacks;
        private HashMapIntObject<Object> root2element;
        private ObjectListResult.Outbound objectList;

        public Result(List<IThreadStack> callstacks, int[] roots) {
            this.callstacks = callstacks;
            this.root2element = new HashMapIntObject();
            this.objectList = new ObjectListResult.Outbound(ThreadStackQuery.this.snapshot, roots);
            for (Object o : this.objectList.getElements()) {
                this.root2element.put(this.objectList.getContext(o).getObjectId(), o);
            }
        }

        public List<?> getChildren(Object parent) {
            IStackFrame frame;
            int[] localIds;
            if (parent instanceof IThreadStack) {
                IStackFrame[] frames = ((IThreadStack)parent).getStackFrames();
                return Arrays.asList(frames);
            }
            if (parent instanceof IStackFrame && (localIds = (frame = (IStackFrame)parent).getLocalObjectsIds()) != null) {
                return this.asList(localIds);
            }
            return this.objectList.getChildren(parent);
        }

        public List<?> getElements() {
            return this.callstacks;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IThreadStack) {
                IStackFrame[] frames = ((IThreadStack)element).getStackFrames();
                return frames != null && frames.length > 0;
            }
            if (element instanceof IStackFrame) {
                IStackFrame frame = (IStackFrame)element;
                int[] objectIds = frame.getLocalObjectsIds();
                return objectIds != null && objectIds.length > 0;
            }
            return this.objectList.hasChildren(element);
        }

        public Object getColumnValue(Object row, int columnIndex) {
            block12: {
                try {
                    if (row instanceof IThreadStack) {
                        IThreadStack stack = (IThreadStack)row;
                        switch (columnIndex) {
                            case 0: {
                                IObject threadObject = ThreadStackQuery.this.snapshot.getObject(stack.getThreadId());
                                return threadObject.getDisplayName();
                            }
                            case 1: {
                                return ThreadStackQuery.this.snapshot.getHeapSize(stack.getThreadId());
                            }
                            case 2: {
                                return ThreadStackQuery.this.snapshot.getRetainedHeapSize(stack.getThreadId());
                            }
                        }
                        break block12;
                    }
                    if (row instanceof IStackFrame) {
                        switch (columnIndex) {
                            case 0: {
                                IStackFrame frame = (IStackFrame)row;
                                return frame.getText();
                            }
                        }
                        break block12;
                    }
                    return this.objectList.getColumnValue(row, columnIndex);
                }
                catch (SnapshotException snapshotException) {}
            }
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.ThreadStackQuery_Column_ObjectStackFrame).decorator((IDecorator)this).comparing((Comparator)new NoCompareComparator()), new Column(Messages.Column_ShallowHeap, Long.TYPE).noTotals(), new Column(Messages.Column_RetainedHeap, Long.TYPE).noTotals().sorting(Column.SortDirection.DESC)};
        }

        public IContextObject getContext(final Object row) {
            if (row instanceof IThreadStack) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((IThreadStack)row).getThreadId();
                    }
                };
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            return this.objectList.getContext(row);
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public URL getIcon(Object row) {
            if (row instanceof IThreadStack) {
                return THREAD_ICON_URL;
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            return this.objectList.getIcon(row);
        }

        public String prefix(Object row) {
            if (row instanceof IThreadStack) {
                return null;
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            String prefix = this.objectList.prefix(row);
            return prefix == null ? Messages.ThreadStackQuery_Label_Local : prefix;
        }

        public String suffix(Object row) {
            if (row instanceof IThreadStack) {
                return null;
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            return this.objectList.suffix(row);
        }

        private List<?> asList(int[] objectIds) {
            ArrayList<Object> answer = new ArrayList<Object>(objectIds.length);
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                answer.add(this.root2element.get(id));
                ++n2;
            }
            return answer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NoCompareComparator
        implements Comparator<Object> {
            NoCompareComparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        }
    }
}

