/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.acquire;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.acquire.JmapVmInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalJavaProcessesUtils {
    static List<JmapVmInfo> getLocalVMsUsingJPS(File jdkHome) throws SnapshotException {
        String jps = "jps";
        if (jdkHome != null && jdkHome.exists()) {
            jps = String.valueOf(jdkHome.getAbsolutePath()) + File.separator + "bin" + File.separator + "jps";
        }
        StreamCollector error = null;
        StreamCollector output = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(jps);
            error = new StreamCollector(p.getErrorStream());
            error.start();
            output = new StreamCollector(p.getInputStream());
            output.start();
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                return null;
            }
            ArrayList<JmapVmInfo> vms = new ArrayList<JmapVmInfo>();
            StringTokenizer tok = new StringTokenizer(output.buf.toString(), "\r\n");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                JmapVmInfo info = LocalJavaProcessesUtils.parseJPSLine(token);
                if (info == null) continue;
                vms.add(info);
            }
            ArrayList<JmapVmInfo> arrayList = vms;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new SnapshotException(Messages.LocalJavaProcessesUtils_ErrorGettingProcessListJPS, (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new SnapshotException(Messages.LocalJavaProcessesUtils_ErrorGettingProcessListJPS, (Throwable)ie);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private static JmapVmInfo parseJPSLine(String line) {
        int firstSpaceIdx = line.indexOf(32);
        if (firstSpaceIdx == -1) {
            return null;
        }
        int pid = Integer.parseInt(line.substring(0, firstSpaceIdx));
        String description = line.substring(firstSpaceIdx);
        return new JmapVmInfo(pid, description, false, null, null);
    }

    static class StreamCollector
    extends Thread {
        InputStream is;
        StringBuilder buf;

        StreamCollector(InputStream is) {
            this.is = is;
            this.buf = new StringBuilder();
        }

        public void run() {
            block15: {
                InputStreamReader isr = null;
                try {
                    try {
                        isr = new InputStreamReader(this.is);
                        BufferedReader br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            this.buf.append(line).append("\r\n");
                        }
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.LocalJavaProcessesUtils_ErrorGettingProcesses, ioe);
                        if (isr != null) {
                            try {
                                isr.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

