/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.PathExpression;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodCallExpression
extends Expression {
    String name;
    List<Expression> parameters;

    public MethodCallExpression(String name, List<Expression> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        List<?> subject = ctx.getSubject();
        if (subject == null) {
            return null;
        }
        if (subject.getClass().isArray()) {
            subject = PathExpression.asList(subject);
        }
        Object[] arguments = new Object[this.parameters.size()];
        int ii = 0;
        while (ii < arguments.length) {
            arguments[ii] = this.parameters.get(ii).compute(ctx);
            ++ii;
        }
        if (subject instanceof IObject && "toString".equals(this.name) && this.parameters.isEmpty()) {
            String name = ((IObject)subject).getClassSpecificName();
            return name != null ? name : ((IObject)subject).getTechnicalName();
        }
        Class<?> subjectClass = subject.getClass();
        Method[] methods = subjectClass.getMethods();
        if (!Modifier.isPublic(subjectClass.getModifiers())) {
            ArrayList<Method> m = new ArrayList<Method>();
            Class<?> superClass = subjectClass;
            while (superClass != null) {
                Class<?>[] classArray = superClass.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    m.addAll(Arrays.asList(c.getMethods()));
                    ++n2;
                }
                superClass = superClass.getSuperclass();
            }
            m.addAll(Arrays.asList(methods));
            methods = m.toArray(new Method[m.size()]);
        }
        int ii2 = 0;
        while (ii2 < methods.length) {
            Class<?>[] parameterTypes;
            if (methods[ii2].getName().equals(this.name) && (parameterTypes = methods[ii2].getParameterTypes()).length == arguments.length) {
                int jj = 0;
                while (jj < arguments.length) {
                    if (arguments[jj] == CompilerImpl.ConstantExpression.NULL) {
                        arguments[jj] = null;
                    }
                    if (arguments[jj] != null && !parameterTypes[jj].isAssignableFrom(arguments[jj].getClass()) && parameterTypes[jj].isAssignableFrom(Pattern.class)) {
                        arguments[jj] = Pattern.compile(PatternUtil.smartFix((String)String.valueOf(arguments[jj]), (boolean)false));
                    }
                    ++jj;
                }
                try {
                    return methods[ii2].invoke(subject, arguments);
                }
                catch (IllegalArgumentException e) {
                    throw new SnapshotException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new SnapshotException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new SnapshotException((Throwable)e);
                }
            }
            ++ii2;
        }
        throw new SnapshotException(MessageUtil.format((String)Messages.MethodCallExpression_Error_MethodNotFound, (Object[])new Object[]{this.name, subject}));
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        for (Expression element : this.parameters) {
            boolean isContextDependent = element.isContextDependent(ctx);
            if (!isContextDependent) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.name);
        buf.append("(");
        Iterator<Expression> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Expression element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
}

