/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private SelectClause selectClause;
    private FromClause fromClause;
    private Expression whereClause;
    private List<Query> unionQueries;

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public void addUnionQuery(Query query) {
        if (this.unionQueries == null) {
            this.unionQueries = new ArrayList<Query>();
        }
        this.unionQueries.add(query);
    }

    public List<Query> getUnionQueries() {
        return this.unionQueries;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SELECT ");
        if (this.selectClause.isDistinct()) {
            buf.append("DISTINCT ");
        }
        if (this.selectClause.isRetainedSet()) {
            buf.append("AS RETAINED SET ");
        }
        if (this.selectClause.getSelectList().isEmpty()) {
            buf.append("* ");
        } else {
            if (this.selectClause.asObjects) {
                buf.append("OBJECTS ");
            }
            Iterator<SelectItem> iter = this.selectClause.getSelectList().iterator();
            while (iter.hasNext()) {
                SelectItem column = iter.next();
                buf.append(column.getExpression());
                if (column.getName() != null) {
                    boolean quote;
                    buf.append(" AS ");
                    String name = column.getName();
                    boolean bl = quote = name.length() == 0 || name.indexOf(32) >= 0;
                    if (quote) {
                        buf.append('\"');
                    }
                    buf.append(name);
                    if (quote) {
                        buf.append('\"');
                    }
                }
                if (iter.hasNext()) {
                    buf.append(", ");
                    continue;
                }
                buf.append(" ");
            }
        }
        buf.append("FROM ");
        buf.append(this.fromClause).append(" ");
        if (this.whereClause != null) {
            buf.append("WHERE ").append(this.whereClause);
        }
        if (this.unionQueries != null) {
            for (Query q : this.unionQueries) {
                buf.append(" UNION ( ").append(q).append(" )");
            }
        }
        return buf.toString();
    }

    public static class FromClause {
        boolean includeObjects;
        boolean includeSubClasses;
        String alias;
        Query subSelect;
        ArrayLong objectAddresses;
        ArrayInt objectIds;
        String className;
        String classNamePattern;
        Expression call;

        public ArrayLong getObjectAddresses() {
            return this.objectAddresses;
        }

        public void addObjectAddress(long objectAddress) {
            if (this.objectAddresses == null) {
                this.objectAddresses = new ArrayLong();
            }
            this.objectAddresses.add(objectAddress);
        }

        public ArrayInt getObjectIds() {
            return this.objectIds;
        }

        public void addObjectId(int objectId) {
            if (this.objectIds == null) {
                this.objectIds = new ArrayInt();
            }
            this.objectIds.add(objectId);
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassNamePattern() {
            return this.classNamePattern;
        }

        public void setClassNamePattern(String classNamePattern) {
            this.classNamePattern = classNamePattern;
        }

        public Expression getCall() {
            return this.call;
        }

        public void setCall(Expression call) {
            this.call = call;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean includeSubClasses() {
            return this.includeSubClasses;
        }

        public void setIncludeSubClasses(boolean includeSubClasses) {
            this.includeSubClasses = includeSubClasses;
        }

        public boolean includeObjects() {
            return this.includeObjects;
        }

        public void setIncludeObjects(boolean includeObjects) {
            this.includeObjects = includeObjects;
        }

        public Query getSubSelect() {
            return this.subSelect;
        }

        public void setSubSelect(Query subSelect) {
            this.subSelect = subSelect;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            if (this.includeObjects) {
                buf.append("OBJECTS ");
            }
            if (this.includeSubClasses) {
                buf.append("INSTANCEOF ");
            }
            if (this.subSelect != null) {
                buf.append("( ").append(this.subSelect).append(" )");
            } else if (this.call != null) {
                buf.append(this.call);
            } else if (this.className != null) {
                buf.append(this.className);
            } else if (this.classNamePattern != null) {
                buf.append("\"").append(this.classNamePattern).append("\"");
            } else if (this.objectIds != null) {
                IteratorInt ee = this.objectIds.iterator();
                while (ee.hasNext()) {
                    buf.append(ee.next());
                    if (!ee.hasNext()) continue;
                    buf.append(",");
                }
            } else {
                IteratorLong ee = this.objectAddresses.iterator();
                while (ee.hasNext()) {
                    buf.append("0x").append(Long.toHexString(ee.next()));
                    if (!ee.hasNext()) continue;
                    buf.append(",");
                }
            }
            if (this.alias != null) {
                buf.append(" ").append(this.alias);
            }
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectClause {
        boolean isDistinct;
        boolean isRetainedSet;
        boolean asObjects;
        List<SelectItem> selectList;

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public void setDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
        }

        public boolean isRetainedSet() {
            return this.isRetainedSet;
        }

        public void setRetainedSet(boolean isRetainedSet) {
            this.isRetainedSet = isRetainedSet;
        }

        public boolean isAsObjects() {
            return this.asObjects;
        }

        public void setAsObjects(boolean asObjects) {
            this.asObjects = asObjects;
        }

        public List<SelectItem> getSelectList() {
            return this.selectList;
        }

        public void setSelectList(List<SelectItem> selectList) {
            this.selectList = selectList;
        }
    }

    public static class SelectItem {
        String name;
        Expression expression;

        public SelectItem(String name, Expression expression) {
            this.name = name;
            this.expression = expression;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

