/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.oql.OQLQueryImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.Query;
import org.eclipse.mat.util.IProgressListener;

public class QueryExpression
extends Expression {
    Query query;
    boolean isDependencyCalculated = false;
    boolean isQueryContextDependent;
    Object queryResult;

    public QueryExpression(Query query) {
        this.query = query;
    }

    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        OQLQueryImpl q;
        if (!this.isDependencyCalculated) {
            this.isQueryContextDependent = this.isContextDependent(ctx);
            this.isDependencyCalculated = true;
            if (!this.isQueryContextDependent) {
                q = new OQLQueryImpl(ctx, this.query);
                this.queryResult = q.execute(ctx.getSnapshot(), null);
            }
        }
        if (this.isQueryContextDependent) {
            q = new OQLQueryImpl(ctx, this.query);
            return q.execute(ctx.getSnapshot(), null);
        }
        return this.queryResult;
    }

    public boolean isContextDependent(EvaluationContext ctx) {
        Expression whereClause = this.query.getWhereClause();
        if (whereClause != null && whereClause.isContextDependent(ctx)) {
            return true;
        }
        for (Query.SelectItem column : this.query.getSelectClause().getSelectList()) {
            if (!column.getExpression().isContextDependent(ctx)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "(" + this.query.toString() + ")";
    }
}

