/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.util.FileUtils;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class ImportReportAction
extends Action {
    private MultiPaneEditor editor;
    private File reportZipFile;

    public ImportReportAction(MultiPaneEditor editor) {
        this(editor, null);
    }

    public ImportReportAction(MultiPaneEditor editor, File reportZipFile) {
        super(Messages.ImportReportAction_OpenReport, MemoryAnalyserPlugin.getImageDescriptor("icons/import_report.gif"));
        this.editor = editor;
        this.reportZipFile = reportZipFile;
    }

    public void run() {
        block6: {
            block5: {
                if (this.reportZipFile != null) break block5;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4098);
                dialog.setText(Messages.ImportReportAction_ImportReport);
                dialog.setFilterExtensions(new String[]{"*_*.zip"});
                dialog.setFilterNames(new String[]{Messages.ImportReportAction_MemoryAnalyzerReports});
                this.prepareFilterSelection(dialog);
                dialog.open();
                String[] names = dialog.getFileNames();
                if (names == null) break block6;
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    try {
                        ImportReportAction.openReport(this.editor, new File(dialog.getFilterPath(), name));
                    }
                    catch (IOException e) {
                        ErrorHelper.logThrowableAndShowMessage(e);
                    }
                    ++n2;
                }
                break block6;
            }
            try {
                ImportReportAction.openReport(this.editor, this.reportZipFile);
            }
            catch (IOException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }
    }

    public static void openReport(MultiPaneEditor editor, File reportZipFile) throws IOException {
        IResult result = ImportReportAction.unzipAndOpen(reportZipFile);
        QueryResult queryResult = new QueryResult(null, String.valueOf(Messages.ImportReportAction_Report) + reportZipFile.getName(), result);
        QueryExecution.displayResult(editor, null, null, queryResult, false);
    }

    public static IResult unzipAndOpen(File reportZipFile) throws IOException {
        DisplayFileResult displayFileResult;
        ZipFile zipFile = null;
        try {
            File targetDir = FileUtils.createTempDirectory((String)"report", null);
            zipFile = new ZipFile(reportZipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(targetDir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                FileOutputStream fout = null;
                FilterOutputStream out = null;
                try {
                    fout = new FileOutputStream(file);
                    out = new BufferedOutputStream(fout);
                    FileUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)out);
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fout == null) continue;
                    fout.close();
                }
                catch (IOException iOException) {}
            }
            displayFileResult = new DisplayFileResult(new File(targetDir, "index.html"));
        }
        catch (Throwable throwable) {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {}
        return displayFileResult;
    }

    private void prepareFilterSelection(FileDialog dialog) {
        File snapshot = this.editor.getQueryContext().getPrimaryFile();
        String name = snapshot.getName();
        int p = name.lastIndexOf(46);
        String prefix = p < 0 ? name : name.substring(0, p);
        dialog.setFilterPath(snapshot.getParentFile().getAbsolutePath());
        dialog.setFileName(String.valueOf(prefix) + "_*.zip");
    }
}

