/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.PaneConfiguration;
import org.eclipse.mat.util.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPaneRegistry
extends RegistryReader<PaneConfiguration> {
    private static final EditorPaneRegistry INSTANCE = new EditorPaneRegistry();
    private Map<String, PaneConfiguration> panesById = new HashMap<String, PaneConfiguration>();
    private Map<String, PaneConfiguration> panesByType = new HashMap<String, PaneConfiguration>();

    public static EditorPaneRegistry instance() {
        return INSTANCE;
    }

    private EditorPaneRegistry() {
        this.init(MemoryAnalyserPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.ui.editorPanes");
    }

    protected synchronized PaneConfiguration createDelegate(IConfigurationElement configElement) throws CoreException {
        PaneConfiguration cfg = new PaneConfiguration(configElement.getAttribute("id"), configElement);
        this.panesById.put(cfg.getId(), cfg);
        IConfigurationElement[] iConfigurationElementArray = configElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.panesByType.put(child.getAttribute("type"), cfg);
            ++n2;
        }
        return cfg;
    }

    protected synchronized void removeDelegate(PaneConfiguration delegate) {
        PaneConfiguration cfg = this.panesById.get(delegate.getId());
        if (cfg == delegate) {
            this.panesById.remove(delegate.getId());
        }
    }

    public PaneConfiguration forPane(String paneId) {
        return this.panesById.get(paneId);
    }

    public AbstractEditorPane createNewPane(String paneId) throws CoreException {
        PaneConfiguration editor = this.forPane(paneId);
        return editor != null ? editor.build() : null;
    }

    public AbstractEditorPane createNewPane(IResult subject, Class<? extends AbstractEditorPane> ignore) {
        try {
            String ignoreClassName = ignore != null ? ignore.getName() : "";
            Class<?> clazz = subject.getClass();
            while (clazz != null && clazz != Object.class) {
                PaneConfiguration paneConfig = this.panesByType.get(clazz.getName());
                if (paneConfig != null && !ignoreClassName.equals(paneConfig.getClassName())) {
                    return paneConfig.build();
                }
                LinkedList interf = new LinkedList();
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> itf = classArray[n2];
                    interf.add(itf);
                    ++n2;
                }
                while (!interf.isEmpty()) {
                    Class current = (Class)interf.removeFirst();
                    paneConfig = this.panesByType.get(current.getName());
                    if (paneConfig != null && !ignoreClassName.equals(paneConfig.getClassName())) {
                        return paneConfig.build();
                    }
                    Class<?>[] classArray2 = current.getInterfaces();
                    int n3 = classArray2.length;
                    n = 0;
                    while (n < n3) {
                        Class<?> itf = classArray2[n];
                        interf.add(itf);
                        ++n;
                    }
                }
                clazz = clazz.getSuperclass();
            }
            return null;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

