/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.acquire;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.query.registry.AnnotatedObjectArgumentsSet;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.acquire.AcquireDialog;
import org.eclipse.mat.ui.internal.acquire.ProviderArgumentsTable;
import org.eclipse.mat.ui.internal.browser.QueryContextHelp;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ProviderArgumentsWizardPage
extends WizardPage
implements ProviderArgumentsTable.ITableListener,
AcquireDialog.ProcessSelectionListener {
    private ProviderArgumentsTable table;
    private AcquireDialog acquireDialog;
    private QueryContextHelp helpPopup;

    public ProviderArgumentsWizardPage(AcquireDialog acquireDialog) {
        super(Messages.ProviderArgumentsWizzardPage_HeapDumpProviderArgumentsTitle, Messages.ProviderArgumentsWizzardPage_HeapDumpProviderArgumentsTitle, null);
        this.acquireDialog = acquireDialog;
    }

    public void createControl(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 2816);
        composite.setLayout((Layout)new GridLayout());
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite tableComposite = new Composite((Composite)composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 0).applyTo((Control)tableComposite);
        Dialog.applyDialogFont((Control)composite);
        this.table = new ProviderArgumentsTable(tableComposite, 65540);
        this.table.addListener(this);
        tableComposite.layout();
        tableComposite.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.acquire_arguments");
        composite.setContent((Control)tableComposite);
        this.setControl((Control)composite);
        this.acquireDialog.addProcessSelectionListener(this);
        this.table.addListener(this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProviderArgumentsWizardPage.this.relocateHelp(false);
            }
        };
        this.getShell().addListener(11, listener);
        this.getShell().addListener(10, listener);
    }

    void updateDescription() {
        this.setDescription(this.table.getProviderDescriptor().getName());
        this.relocateHelp(true);
        this.getContainer().updateButtons();
    }

    public ProviderArgumentsTable getTable() {
        return this.table;
    }

    public AnnotatedObjectArgumentsSet getArgumentSet() {
        return this.table.getArgumentSet();
    }

    public void onInputChanged() {
        this.updateDescription();
        this.acquireDialog.updateFileName();
    }

    public void onError(String message) {
        this.setErrorMessage(message);
        this.onFocus(null);
    }

    public void onFocus(String message) {
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage(), 3);
        } else if (message != null) {
            this.setMessage(message, 1);
        } else {
            this.setMessage(this.table.getProviderDescriptor().getName());
        }
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.table != null && this.table.getArgumentSet() != null && this.table.getArgumentSet().isExecutable();
    }

    public void relocateHelp(final boolean create) {
        final AnnotatedObjectArgumentsSet argumentSet = this.table.getArgumentSet();
        if (argumentSet == null) {
            return;
        }
        if (argumentSet.getDescriptor().isHelpAvailable() && (create || this.helpPopup != null && this.helpPopup.getShell() != null)) {
            if (this.getShell() == null) {
                this.helpPopup.close();
                return;
            }
            this.getShell().getDisplay().timerExec(100, new Runnable(){

                public void run() {
                    if (ProviderArgumentsWizardPage.this.getShell() != null && !ProviderArgumentsWizardPage.this.getShell().isDisposed()) {
                        Rectangle myBounds = ProviderArgumentsWizardPage.this.getShell().getBounds();
                        Rectangle helpBounds = new Rectangle(myBounds.x, myBounds.y + myBounds.height, myBounds.width, -1);
                        if (ProviderArgumentsWizardPage.this.helpPopup != null) {
                            if (!create) {
                                ProviderArgumentsWizardPage.this.helpPopup.resize(helpBounds);
                                return;
                            }
                            ProviderArgumentsWizardPage.this.helpPopup.close();
                        }
                        ProviderArgumentsWizardPage.this.helpPopup = new QueryContextHelp(ProviderArgumentsWizardPage.this.getShell(), argumentSet.getDescriptor(), helpBounds);
                        ProviderArgumentsWizardPage.this.helpPopup.open();
                    }
                }
            });
        }
    }

    public void processSelected(AnnotatedObjectArgumentsSet argumentSet) {
        this.table.providerSelected(argumentSet);
    }
}

