/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class OQLPane
extends CompositeHeapEditorPane {
    private StyledText queryString;
    private Action executeAction;
    private Action copyQueryStringAction;

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 66048);
        this.queryString = new StyledText((Composite)sash, 66);
        this.queryString.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.queryString.setText(Messages.OQLPane_F1ForHelp);
        this.queryString.selectAll();
        this.queryString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OQLPane.this.queryString.setStyleRanges(new StyleRange[0]);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.queryString, "org.eclipse.mat.ui.help.oql");
        this.queryString.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 && (e.stateMask & SWT.MOD1) != 0) {
                    OQLPane.this.executeAction.run();
                    e.doit = false;
                }
            }
        });
        this.queryString.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars actionBars = OQLPane.this.getEditor().getEditorSite().getActionBars();
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)OQLPane.this.copyQueryStringAction);
                actionBars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.queryString.setFocus();
        this.createContainer((Composite)sash);
        sash.setWeights(new int[]{1, 4});
        this.makeActions();
        this.hookContextMenu();
    }

    private void makeActions() {
        this.executeAction = new ExecuteQueryAction();
        IWorkbenchWindow window = this.getEditorSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction globalAction = ActionFactory.COPY.create(window);
        this.copyQueryStringAction = new Action(){

            public void run() {
                OQLPane.this.queryString.copy();
            }
        };
        this.copyQueryStringAction.setAccelerator(globalAction.getAccelerator());
    }

    /*
     * Unable to fully structure code
     */
    protected int findInText(String query, int line, int column) {
        charAt = 0;
        if (true) ** GOTO lbl6
        block0: while (true) {
            if ((c = query.charAt(charAt++)) != '\n') ** GOTO lbl-1000
            --line;
            while (line > 1) lbl-1000:
            // 2 sources

            {
                if (charAt < query.length()) continue block0;
            }
            break;
        }
        while (column > 1 && charAt < query.length()) {
            if ((c = query.charAt(charAt++)) == '\t') {
                column -= 8;
                continue;
            }
            --column;
        }
        return charAt;
    }

    private void hookContextMenu() {
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IAction)this.executeAction);
        super.contributeToToolBar(manager);
    }

    public void initWithArgument(Object param) {
        if (param instanceof String) {
            this.queryString.setText((String)param);
            this.executeAction.run();
        } else if (param instanceof QueryResult) {
            QueryResult queryResult = (QueryResult)param;
            this.initQueryResult(queryResult, null);
        } else if (param instanceof PaneState) {
            this.queryString.setText(((PaneState)param).getIdentifier());
            new ExecuteQueryAction((PaneState)param).run();
        }
    }

    private void initQueryResult(QueryResult queryResult, PaneState state) {
        IOQLQuery.Result subject = (IOQLQuery.Result)queryResult.getSubject();
        this.queryString.setText(subject.getOQLQuery());
        AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane((IResult)subject, this.getClass());
        if (state == null) {
            for (PaneState child : this.getPaneState().getChildren()) {
                if (!this.queryString.getText().equals(child.getIdentifier())) continue;
                state = child;
                break;
            }
            if (state == null) {
                state = new PaneState(PaneState.PaneType.COMPOSITE_CHILD, this.getPaneState(), this.queryString.getText(), true);
                state.setImage(this.getTitleImage());
            }
        }
        pane.setPaneState(state);
        this.createResultPane(pane, queryResult);
    }

    public void setFocus() {
        this.queryString.setFocus();
    }

    public void createExceptionPane(Exception cause, String queryString) throws PartInitException {
        StringBuilder buf = new StringBuilder(256);
        buf.append(Messages.OQLPane_ExecutedQuery);
        buf.append(queryString);
        Throwable t = null;
        if (cause instanceof SnapshotException) {
            buf.append(Messages.OQLPane_ProblemReported);
            buf.append(cause.getMessage());
            t = cause.getCause();
        } else {
            t = cause;
        }
        if (t != null) {
            buf.append("\n\n");
            StringWriter w = new StringWriter();
            PrintWriter o = new PrintWriter(w);
            t.printStackTrace(o);
            o.flush();
            buf.append(w.toString());
        }
        try {
            AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane("TextViewPane");
            if (pane == null) {
                throw new PartInitException(Messages.OQLPane_PaneNotFound);
            }
            this.createResultPane(pane, buf.toString());
        }
        catch (CoreException e) {
            throw new PartInitException(ErrorHelper.createErrorStatus(e));
        }
    }

    public String getTitle() {
        return "OQL";
    }

    public Image getTitleImage() {
        return MemoryAnalyserPlugin.getImage("icons/oql.gif");
    }

    private class ExecuteQueryAction
    extends Action {
        private PaneState state;

        public ExecuteQueryAction() {
            this(null);
        }

        public ExecuteQueryAction(PaneState state) {
            this.state = state;
            this.setText(Messages.OQLPane_ExecuteQuery);
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/execute_query.gif"));
        }

        public void run() {
            try {
                String query = OQLPane.this.queryString.getSelectionText();
                Point queryRange = OQLPane.this.queryString.getSelectionRange();
                if ("".equals(query)) {
                    query = OQLPane.this.queryString.getText();
                    queryRange = new Point(0, OQLPane.this.queryString.getCharCount());
                }
                try {
                    SnapshotFactory.createQuery((String)query);
                    new OQLJob(OQLPane.this, query, this.state).schedule();
                }
                catch (OQLParseException e) {
                    int start = OQLPane.this.findInText(query, e.getLine(), e.getColumn());
                    StyleRange style2 = new StyleRange();
                    style2.start = start + queryRange.x;
                    style2.length = queryRange.y - start;
                    style2.foreground = OQLPane.this.queryString.getDisplay().getSystemColor(3);
                    OQLPane.this.queryString.replaceStyleRanges(0, OQLPane.this.queryString.getCharCount(), new StyleRange[]{style2});
                    OQLPane.this.createExceptionPane((Exception)((Object)e), query);
                }
                catch (Exception e) {
                    OQLPane.this.createExceptionPane(e, query);
                }
            }
            catch (PartInitException e1) {
                ErrorHelper.logThrowableAndShowMessage(e1, Messages.OQLPane_ErrorExecutingQuery);
            }
        }
    }

    class OQLJob
    extends AbstractPaneJob {
        String queryString;
        PaneState state;

        public OQLJob(AbstractEditorPane pane, String queryString, PaneState state) {
            super(queryString.toString(), pane);
            this.queryString = queryString;
            this.state = state;
            this.setUser(true);
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                QueryDescriptor descriptor = QueryRegistry.instance().getQuery("oql");
                ArgumentSet argumentSet = descriptor.createNewArgumentSet(OQLPane.this.getEditor().getQueryContext());
                argumentSet.setArgumentValue("queryString", (Object)this.queryString);
                final QueryResult result = argumentSet.execute((IProgressListener)new ProgressMonitorWrapper(monitor));
                OQLPane.this.queryString.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        OQLPane.this.initQueryResult(result, OQLJob.this.state);
                    }
                });
            }
            catch (Exception e) {
                OQLPane.this.queryString.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            OQLPane.this.createExceptionPane(e, OQLJob.this.queryString);
                        }
                        catch (PartInitException pie) {
                            ErrorHelper.logThrowable(pie);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

