/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.hooks;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.mtj.internal.core.hooks.Debug;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.util.ManifestElement;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceClassVisitor;
import org.osgi.framework.BundleException;

public class MTJClassLoadingHook
implements ClassLoadingHook {
    private static Type IFile_Type = Type.getType((String)"Lorg/eclipse/core/resources/IFile;");
    private static final String SOURCE_FILE_CLASS = "org.eclipse.jdt.internal.core.builder.SourceFile";
    private static String SOURCE_MAPPER_CLASS = "org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapperAccess";
    private static Type SourceFile_Type = Type.getType((String)"Lorg/eclipse/jdt/internal/core/builder/SourceFile;");
    private static Type SourceMapperAccess_Type = Type.getType((String)"Lorg/eclipse/mtj/internal/core/hook/sourceMapper/SourceMapperAccess;");
    private static ManifestElement[] sourceMapperManifestElements;

    private static ManifestElement[] getSourceMapperManifestElements() {
        block3: {
            if (sourceMapperManifestElements == null) {
                try {
                    sourceMapperManifestElements = ManifestElement.parseHeader((String)"DynamicImport-Package", (String)"org.eclipse.mtj.internal.core.hook.sourceMapper");
                }
                catch (BundleException e) {
                    if (!Debug.DEBUG_GENERAL) break block3;
                    e.printStackTrace();
                }
            }
        }
        return sourceMapperManifestElements;
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        return false;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        block7: {
            if ("org.eclipse.jdt.core".equals(data.getSymbolicName())) {
                ManifestElement[] dynamicElements = MTJClassLoadingHook.getSourceMapperManifestElements();
                Class<?> clazz = delegate.getClass();
                Method dynamicImportMethod = null;
                try {
                    dynamicImportMethod = clazz.getMethod("addDynamicImportPackage", dynamicElements.getClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (dynamicImportMethod != null) {
                    if (Debug.DEBUG_GENERAL) {
                        System.out.println("Adding dynamic import into JDT Core bundle");
                    }
                    try {
                        dynamicImportMethod.invoke((Object)delegate, new Object[]{dynamicElements});
                    }
                    catch (Exception e) {
                        if (!Debug.DEBUG_GENERAL) break block7;
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        byte[] processed = null;
        if (SOURCE_FILE_CLASS.equals(name) || SOURCE_MAPPER_CLASS.equals(name)) {
            processed = this.rewriteSourceFileClass(name, classbytes);
        }
        return processed;
    }

    private byte[] rewriteSourceFileClass(String name, byte[] classBytes) {
        byte[] rewritten = classBytes;
        if (Debug.DEBUG_GENERAL) {
            System.out.println(String.valueOf(name) + " located.  Rewriting class bytes.");
        }
        ClassReader classReader = new ClassReader(classBytes);
        ClassWriter classWriter = new ClassWriter(1);
        ClassAdapter adapter = null;
        adapter = SOURCE_FILE_CLASS.equals(name) ? new SourceFileClassAdapter((ClassVisitor)classWriter) : new SourceMapperAccessClassAdapter((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)adapter, 8);
        rewritten = classWriter.toByteArray();
        if (Debug.DEBUG_GENERAL) {
            StringWriter stringWriter = new StringWriter();
            ClassReader reader = new ClassReader(rewritten);
            TraceClassVisitor writer = new TraceClassVisitor(new PrintWriter(stringWriter));
            reader.accept((ClassVisitor)writer, 2);
            System.out.println(stringWriter);
        }
        return rewritten;
    }

    class GetContentsMethodVisitor
    extends MethodAdapter {
        boolean foundReturn;

        public GetContentsMethodVisitor(MethodVisitor mv) {
            super(mv);
            this.foundReturn = false;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 180 && name.equals("resource") && !this.foundReturn) {
                this.insertMappedResourceCode();
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitInsn(int opcode) {
            if (!this.foundReturn && opcode == 176) {
                if (Debug.DEBUG_GENERAL) {
                    System.out.println("Found ARETURN in method.");
                }
                this.foundReturn = true;
            }
            super.visitInsn(opcode);
        }

        private void insertDebugMessageCode(String message) {
            if (Debug.DEBUG_GENERAL) {
                super.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
                super.visitLdcInsn((Object)message);
                super.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
            }
        }

        private void insertMappedResourceCode() {
            if (Debug.DEBUG_GENERAL) {
                System.out.println("Inserting mapped resource lookup code into method.");
            }
            Label endLabel = new Label();
            this.insertDebugMessageCode("Rewritten SourceFile");
            super.visitInsn(87);
            super.visitVarInsn(25, 0);
            super.visitFieldInsn(180, SourceFile_Type.getInternalName(), "resource", IFile_Type.getDescriptor());
            super.visitMethodInsn(184, SourceMapperAccess_Type.getInternalName(), "getMappedSourceFile", Type.getMethodDescriptor((Type)IFile_Type, (Type[])new Type[]{IFile_Type}));
            super.visitInsn(89);
            super.visitJumpInsn(199, endLabel);
            this.insertDebugMessageCode("Mapped resource was null");
            super.visitInsn(87);
            this.insertDebugMessageCode("Using raw resource");
            super.visitVarInsn(25, 0);
            super.visitFieldInsn(180, SourceFile_Type.getInternalName(), "resource", IFile_Type.getDescriptor());
            this.visitLabel(endLabel);
            this.insertDebugMessageCode("Finished generated code");
        }
    }

    class IsHookInstalledMethodVisitor
    extends MethodAdapter {
        public IsHookInstalledMethodVisitor(MethodVisitor mv) {
            super(mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 3) {
                opcode = 4;
            }
            super.visitInsn(opcode);
        }
    }

    class SourceFileClassAdapter
    extends ClassAdapter {
        public SourceFileClassAdapter(ClassVisitor cv) {
            super(cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Object methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals("getContents")) {
                if (Debug.DEBUG_GENERAL) {
                    System.out.println("SourceFile#getContents spotted.  Rewriting method.");
                }
                methodVisitor = new GetContentsMethodVisitor((MethodVisitor)methodVisitor);
            }
            return methodVisitor;
        }
    }

    class SourceMapperAccessClassAdapter
    extends ClassAdapter {
        public SourceMapperAccessClassAdapter(ClassVisitor cv) {
            super(cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Object methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals("isHookCodeInstalled")) {
                if (Debug.DEBUG_GENERAL) {
                    System.out.println("SourceMapperAccess#isHookInstalled spotted.  Rewriting method.");
                }
                methodVisitor = new IsHookInstalledMethodVisitor((MethodVisitor)methodVisitor);
            }
            return methodVisitor;
        }
    }
}

