/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MTJIncrementalProjectBuilder
extends IncrementalProjectBuilder {
    protected final IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        BuildStateMachine stateMachine = BuildStateMachine.getInstance(this.getMTJProject());
        IProject[] result = null;
        BuildSpecManipulator manipulator = new BuildSpecManipulator(this.getProject());
        if (stateMachine.getCurrentState() == null) {
            stateMachine.start(monitor);
        }
        this.onStateEnter(stateMachine, monitor);
        if (kind == 6) {
            this.doClean(6, monitor);
        }
        result = this.doBuild(kind, args, monitor);
        this.onStateExit(stateMachine, monitor);
        if (manipulator.isLastBuilder(this.getBuilderId())) {
            stateMachine.changeState(MTJBuildState.POST_BUILD, monitor);
        }
        return result;
    }

    protected final void clean(IProgressMonitor monitor) throws CoreException {
        this.doClean(15, monitor);
    }

    protected void onStateEnter(BuildStateMachine stateMachine, IProgressMonitor monitor) throws CoreException {
        stateMachine.changeState(this.getEnterState(), monitor);
    }

    protected void onStateExit(BuildStateMachine stateMachine, IProgressMonitor monitor) throws CoreException {
        stateMachine.changeState(this.getExitState(), monitor);
    }

    protected IMTJProject getMTJProject() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        return midletSuite;
    }

    protected void assertCancelation(IProgressMonitor monitor, boolean forgetBuildState) {
        if (monitor.isCanceled()) {
            if (forgetBuildState) {
                this.forgetLastBuiltState();
            }
            throw new OperationCanceledException();
        }
    }

    protected abstract IProject[] doBuild(int var1, Map<?, ?> var2, IProgressMonitor var3) throws CoreException;

    protected abstract void doClean(int var1, IProgressMonitor var2) throws CoreException;

    protected abstract String getBuilderId();

    protected abstract MTJBuildState getEnterState();

    protected abstract MTJBuildState getExitState();
}

