/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.export.AntennaBuildExport;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.statemachine.AbstractState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateAntTaskState
extends AbstractState {
    private StateMachine stateMachine;
    private Document document;
    private String dependencies;
    private String buildFolder;
    private String buildFile;
    private IMidletSuiteProject suiteProject;

    public String getBuildFolder() {
        return this.buildFolder;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public AbstractCreateAntTaskState(StateMachine _stateMachine, IMidletSuiteProject _suiteProject, Document _document, String buildFolder, String buildfile) {
        super(null);
        if (_stateMachine == null) {
            throw new IllegalArgumentException(Messages.AbstractCreateAntTaskState_stateMachineNotNull);
        }
        this.stateMachine = _stateMachine;
        if (_suiteProject == null) {
            throw new IllegalArgumentException(Messages.AbstractCreateAntTaskState_projectCanNotBeNull);
        }
        this.suiteProject = _suiteProject;
        if (_document == null) {
            throw new IllegalArgumentException(Messages.AbstractCreateAntTaskState_documentNotNull);
        }
        this.document = _document;
        this.dependencies = "";
        this.buildFolder = buildFolder;
        this.buildFile = buildfile;
    }

    protected abstract void onEnter(MTJRuntime var1) throws AntennaExportException;

    @Override
    protected void onEnter() {
        MTJRuntimeList runtimeList = this.getMidletSuiteProject().getRuntimeList();
        for (MTJRuntime runtime : runtimeList) {
            try {
                this.onEnter(runtime);
            }
            catch (AntennaExportException e) {
                MTJLogger.log(4, e);
            }
        }
        this.stateMachine.postEvent(new AntennaBuildExport.CreateAntTaskDoneEvent());
    }

    @Override
    protected void onExit() {
    }

    public void setDependencies(String _dependencies) {
        if (_dependencies != null) {
            this.dependencies = _dependencies;
        }
    }

    protected IMidletSuiteProject getMidletSuiteProject() {
        return this.suiteProject;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    protected StateMachine getStateMachine() {
        return this.stateMachine;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Set<IProject> getRequiredProjects(IProject _project) {
        HashSet<IProject> result = new HashSet<IProject>();
        try {
            IProject[] iProjectArray = _project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject required = iProjectArray[n2];
                result.addAll(this.getRequiredProjects(required));
                result.add(required);
                ++n2;
            }
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        return result;
    }

    protected String getFormatedName(String _name) {
        return _name.replace(" ", "_");
    }

    protected String getDependencies(MTJRuntime runtime) {
        String[] deps;
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = deps = this.getDependencies().split(",");
        int n = deps.length;
        int n2 = 0;
        while (n2 < n) {
            String dep = stringArray[n2];
            if (dep.length() > 0) {
                buffer.append(NLS.bind((String)"{0}-{1}", (Object[])new String[]{dep, this.getFormatedName(runtime.getName())}));
            }
            ++n2;
        }
        return buffer.toString();
    }
}

