/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntInitTaskState
extends AbstractCreateAntTaskState {
    public CreateAntInitTaskState(StateMachine _stateMachine, IMidletSuiteProject _suiteProject, Document _document, String buildFolder, String buildFile) {
        super(_stateMachine, _suiteProject, _document, buildFolder, buildFile);
    }

    protected void onEnter(MTJRuntime runtime) throws AntennaExportException {
        Document document = this.getDocument();
        Element root = document.getDocumentElement();
        IProject project = this.getMidletSuiteProject().getProject();
        Set<IProject> requiredProjects = this.getRequiredProjects(project);
        String configName = this.getFormatedName(runtime.getName());
        Element init = XMLUtils.createTargetElement(document, root, NLS.bind((String)"init-{0}", (Object)configName), this.getDependencies(runtime));
        String[] stringArray = this.getTargetProjectDirectories(this.getMidletSuiteProject().getProject(), configName);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            Element mkdir = document.createElement("mkdir");
            init.appendChild(mkdir);
            mkdir.setAttribute("dir", dir);
            ++n2;
        }
        Element copy = document.createElement("copy");
        init.appendChild(copy);
        copy.setAttribute("tofile", NLS.bind((String)"deployed/{0}/{1}", (Object[])new String[]{configName, this.getMidletSuiteProject().getJadFileName()}));
        copy.setAttribute("file", "Application Descriptor");
        for (IProject required : requiredProjects) {
            String[] stringArray2 = this.getRequiredProjectDirectories(required, configName);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String dir = stringArray2[n4];
                Element mkdir = document.createElement("mkdir");
                init.appendChild(mkdir);
                mkdir.setAttribute("dir", dir);
                ++n4;
            }
        }
    }

    private String[] getRequiredProjectDirectories(IProject _project, String configName) {
        String projectName = this.getFormatedName(_project.getName());
        Object[] values = new String[]{this.getBuildFolder(), configName, projectName};
        return new String[]{NLS.bind((String)"{0}/{1}/{2}/", (Object[])values), NLS.bind((String)"deployed/{0}/", (Object)configName), NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])values), NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])values)};
    }

    private String[] getTargetProjectDirectories(IProject _project, String configName) {
        String projectName = this.getFormatedName(_project.getName());
        Object[] values = new String[]{this.getBuildFolder(), configName, projectName};
        return new String[]{NLS.bind((String)"{0}/{1}/{2}/", (Object[])values), NLS.bind((String)"deployed/{0}/", (Object)configName), NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])values), NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])values), NLS.bind((String)"{0}/{1}/{2}/bin/", (Object[])values)};
    }
}

