/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.LibraryCollector;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntPackageTaskState
extends AbstractCreateAntTaskState {
    public CreateAntPackageTaskState(StateMachine machine, IMidletSuiteProject project, Document _document, String buildFolder, String buildFile) {
        super(machine, project, _document, buildFolder, buildFile);
    }

    protected void onEnter(MTJRuntime runtime) throws AntennaExportException {
        Document document = this.getDocument();
        Element root = document.getDocumentElement();
        String configName = this.getFormatedName(runtime.getName());
        Element target = XMLUtils.createTargetElement(document, root, NLS.bind((String)"package-{0}", (Object)configName), this.getDependencies(runtime));
        this.writePackageTask(target, runtime);
    }

    private void writePackageTask(Element target, MTJRuntime runtime) throws AntennaExportException {
        String[] dirs;
        IPath[] libPaths;
        IProject project = this.getMidletSuiteProject().getProject();
        Document document = this.getDocument();
        String configName = runtime.getName().replace(" ", "_");
        Element wtkPackage = document.createElement("wtkpackage");
        String projectName = this.getFormatedName(project.getName());
        Object[] values = new String[]{configName, this.getMidletSuiteProject().getJadFileName()};
        wtkPackage.setAttribute("jadfile", NLS.bind((String)"deployed/{0}/{1}", (Object[])values));
        values = new String[]{configName, this.getMidletSuiteProject().getJarFilename()};
        wtkPackage.setAttribute("jarfile", NLS.bind((String)"deployed/{0}/{1}", (Object[])values));
        wtkPackage.setAttribute("autoversion", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", "do-autoversion", "}"}));
        wtkPackage.setAttribute("obfuscate", NLS.bind((String)"${0}{1}{2}", (Object[])new String[]{"{", "do-obfuscate", "}"}));
        wtkPackage.setAttribute("preverify", "true");
        StringBuffer bootClassPathString = new StringBuffer();
        IPath[] iPathArray = libPaths = this.resolveLibraryPaths(this.getMidletSuiteProject(), false);
        int n = libPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            bootClassPathString.append(path.toOSString()).append(":");
            ++n2;
        }
        wtkPackage.setAttribute("bootclasspath", bootClassPathString.toString());
        StringBuffer libClassPathString = new StringBuffer();
        IPath[] iPathArray2 = libPaths = this.resolveLibraryPaths(this.getMidletSuiteProject(), true);
        int n3 = libPaths.length;
        n = 0;
        while (n < n3) {
            IPath path = iPathArray2[n];
            libClassPathString.append(path.toOSString()).append(":");
            ++n;
        }
        wtkPackage.setAttribute("libclasspath", libClassPathString.toString());
        target.appendChild(wtkPackage);
        String[] stringArray = dirs = new String[]{"{0}/{1}/{2}/bin/", "{0}/{1}/{2}/resources/"};
        int n4 = dirs.length;
        n3 = 0;
        while (n3 < n4) {
            String dir = stringArray[n3];
            Element fileset = document.createElement("fileset");
            wtkPackage.appendChild(fileset);
            fileset.setAttribute("dir", NLS.bind((String)dir, (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(projectName)}));
            ++n3;
        }
    }

    private IPath[] resolveLibraryPaths(IMidletSuiteProject midletSuiteProject, boolean excludeNonExported) throws AntennaExportException {
        IJavaProject javaProject = this.getMidletSuiteProject().getJavaProject();
        LibraryCollector collector = new LibraryCollector();
        try {
            collector.getRunner().run(javaProject, collector, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exc) {
            throw new AntennaExportException(exc, "Unable to resolve library dependecies.");
        }
        return collector.getLibraryPaths(excludeNonExported);
    }
}

