/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;

public class PreverificationUtils {
    public static String getErrorText(IPreverificationError error) {
        StringBuffer errorText = new StringBuffer();
        String detail = error.getDetail();
        if (detail != null && detail.length() > 0) {
            errorText.append(detail);
        } else {
            PreverificationUtils.appendErrorInformation(errorText, error);
        }
        return errorText.toString();
    }

    private static void appendErrorInformation(StringBuffer errorText, IPreverificationError error) {
        PreverificationUtils.appendErrorTypeInformation(errorText, error);
        if (error.getType() != PreverificationErrorType.FINALIZERS) {
            PreverificationUtils.appendErrorLocationInformation(errorText, error);
        }
    }

    private static void appendErrorLocationInformation(StringBuffer errorText, IPreverificationError error) {
        IClassErrorInformation classInfo = ((IPreverificationErrorLocation)error.getLocation()).getClassInformation();
        switch (((IPreverificationErrorLocation)error.getLocation()).getLocationType().getTypeCode()) {
            case 0: {
                errorText.append(" in class ").append(classInfo.getName()).append(" or superclass");
            }
        }
    }

    private static void appendErrorTypeInformation(StringBuffer errorText, IPreverificationError error) {
        switch (((PreverificationErrorType)error.getType()).getErrorCode()) {
            case 3: {
                errorText.append("Finalizers not allowed");
                break;
            }
            case 2: {
                errorText.append("Floating point not allowed");
                break;
            }
            case 4: {
                errorText.append("Missing type");
                break;
            }
            case 1: {
                errorText.append("Native method implementations not allowed");
                break;
            }
            case 5: {
                errorText.append("Unknown error during preverification");
            }
        }
    }

    private PreverificationUtils() {
    }
}

