/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifier;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierParameters;
import org.eclipse.mtj.internal.core.util.Utils;

public class StandardPreverifierFactory {
    private static final String optionNoFp = "-nofp";
    private static final String optionNoFinalize = "-nofinalize";
    private static final String optionNoNative = "-nonative";
    private static final String optionTarget = "-target";
    private static final Pattern PATTERN_NO_FP = Pattern.compile("\\s+-nofp\\s+");
    private static final Pattern PATTERN_NO_FINALIZE = Pattern.compile("\\s+-nofinalize\\s+");
    private static final Pattern PATTERN_NO_NATIVE = Pattern.compile("\\s+-nonative\\s+");
    private static final Pattern PATTERN_TARGET = Pattern.compile("\\s+-target\\s+");
    private static final Map<File, StandardPreverifierParameters> testedPrograms = new HashMap<File, StandardPreverifierParameters>();

    public static IPreverifier createPreverifier(File preverifierExecutable) throws CoreException {
        StandardPreverifierParameters parameters;
        StandardPreverifier preverifier = null;
        if (preverifierExecutable != null && (parameters = StandardPreverifierFactory.getParameters(preverifierExecutable)) != null && (parameters.cldc10.length != 0 || parameters.cldc11.length != 0)) {
            preverifier = StandardPreverifierFactory.createPreverifier(preverifierExecutable, parameters);
        }
        return preverifier;
    }

    private static StandardPreverifier createPreverifier(File preverifierExecutable, StandardPreverifierParameters parameters) {
        StandardPreverifier preverifier = new StandardPreverifier();
        preverifier.setParameters(parameters);
        preverifier.setPreverifierExecutable(preverifierExecutable);
        return preverifier;
    }

    private static StandardPreverifierParameters getParameters(File preverifierExecutable) throws CoreException {
        StandardPreverifierParameters parameters = testedPrograms.get(preverifierExecutable);
        if (parameters == null && StandardPreverifierFactory.executableExists(preverifierExecutable)) {
            parameters = StandardPreverifierFactory.collectParameters(preverifierExecutable);
            testedPrograms.put(preverifierExecutable, parameters);
        }
        return parameters;
    }

    private static StandardPreverifierParameters collectParameters(File preverifierExecutable) throws CoreException {
        ArrayList<String> cldc10 = new ArrayList<String>();
        ArrayList<String> cldc11 = new ArrayList<String>();
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        String[] commandLine = new String[]{preverifierExecutable.toString()};
        Utils.getProcessOutput("Sun Preverifier", commandLine, stdout, stderr);
        if (StandardPreverifierFactory.find(stdout, PATTERN_TARGET) || StandardPreverifierFactory.find(stderr, PATTERN_TARGET)) {
            cldc10.add(optionTarget);
            cldc10.add("CLDC1.0");
            cldc11.add(optionTarget);
            cldc11.add("CLDC1.1");
        }
        if (StandardPreverifierFactory.find(stdout, PATTERN_NO_FP) || StandardPreverifierFactory.find(stderr, PATTERN_NO_FP)) {
            cldc10.add(optionNoFp);
        }
        if (StandardPreverifierFactory.find(stdout, PATTERN_NO_FINALIZE) || StandardPreverifierFactory.find(stderr, PATTERN_NO_FINALIZE)) {
            cldc10.add(optionNoFinalize);
            cldc11.add(optionNoFinalize);
        }
        if (StandardPreverifierFactory.find(stdout, PATTERN_NO_NATIVE) || StandardPreverifierFactory.find(stderr, PATTERN_NO_NATIVE)) {
            cldc10.add(optionNoNative);
            cldc11.add(optionNoNative);
        }
        StandardPreverifierParameters params = new StandardPreverifierParameters();
        params.cldc10 = cldc10.toArray(new String[cldc10.size()]);
        params.cldc11 = cldc11.toArray(new String[cldc11.size()]);
        return params;
    }

    private static boolean find(StringBuffer buffer, Pattern pattern) {
        return pattern.matcher(buffer).find();
    }

    private static boolean executableExists(File executable) {
        boolean exists = executable.exists();
        if (!exists) {
            File withExe = new File(String.valueOf(executable.toString()) + ".exe");
            exists = withExe.exists();
        }
        return exists;
    }

    private StandardPreverifierFactory() {
    }
}

