/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.mtj.internal.core.build.preverifier.builder.ResourceDeltaBuilder;
import org.eclipse.mtj.internal.core.util.RequiredProjectsCPEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

public class PreverificationBuilder
extends MTJIncrementalProjectBuilder {
    private static BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.getInstance();
    private static BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();

    public static void cleanProject(IProject project, boolean cleanDeployed, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder preverified;
        IFolder oldRuntimeFolder;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_0, (Object)project));
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        BuildInfo buildInfo = new BuildInfo(15, new HashMap(), javaProject);
        IFolder oldVerifiedFolder = project.getFolder(MTJCore.getVerifiedOutputDirectoryName());
        if (oldVerifiedFolder.exists()) {
            Utils.clearContainer((IContainer)oldVerifiedFolder, monitor);
            oldVerifiedFolder.delete(true, monitor);
        }
        if ((oldRuntimeFolder = project.getFolder(".mtj.tmp").getFolder("runtime")).exists()) {
            Utils.clearContainer((IContainer)oldRuntimeFolder, monitor);
            oldRuntimeFolder.delete(true, monitor);
        }
        if ((preverified = buildInfo.getMidletSuite().getVerifiedOutputFolder(monitor)).exists()) {
            IResource[] children;
            IResource[] iResourceArray = children = preverified.members();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 2) {
                    Utils.clearContainer((IContainer)((IFolder)resource), monitor);
                } else {
                    resource.delete(true, monitor);
                }
                ++n2;
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_1, (Object)project));
        }
    }

    private void clearPreprocessorMarkers() throws CoreException {
        this.getProject().deleteMarkers("org.eclipse.mtj.core.problem", false, 0);
    }

    private void createNoPreverifierFoundMarker() throws CoreException {
        final IProject project = this.getProject();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = project.createMarker("org.eclipse.mtj.core.problem");
                marker.setAttribute("message", (Object)BuilderMessages.PreverificationBuilder_PreverifierNotFoundErrorMessage);
                marker.setAttribute("severity", 2);
            }
        };
        project.getWorkspace().run(runnable, null);
    }

    private IJavaProject[] getRequiredProjects(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        RequiredProjectsCPEntryVisitor visitor = new RequiredProjectsCPEntryVisitor();
        visitor.getRunner().run(javaProject, visitor, monitor);
        ArrayList<IJavaProject> projects = visitor.getRequiredProjects();
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    private void preverifyLibraries(BuildInfo buildInfo, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        IProject project = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_47) + project);
        }
        if (project != null && project.isAccessible()) {
            monitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_48) + project.getName());
            buildInfo.setCurrentResourceDelta(this.getDelta(project));
            ResourceDeltaBuilder deltaBuilder = new ResourceDeltaBuilder(buildInfo);
            deltaBuilder.preverifyLibraries(monitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_49) + project);
        }
    }

    private void preverifyProject(BuildInfo buildInfo, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        IProject project = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_50) + project);
        }
        if (project != null && project.isAccessible()) {
            monitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_51) + project.getName());
            buildInfo.setCurrentResourceDelta(this.getDelta(project));
            ResourceDeltaBuilder deltaBuilder = new ResourceDeltaBuilder(buildInfo);
            deltaBuilder.build(monitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_52) + project);
        }
    }

    private void setResourcesAsDerived(IFolder verifiedFolder, IProgressMonitor monitor) throws CoreException {
        verifiedFolder.refreshLocal(2, monitor);
        Utils.setResourcesAsDerived((IContainer)verifiedFolder);
    }

    protected IProject[] doBuild(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IJavaProject rootJavaProject;
        this.clearPreprocessorMarkers();
        IProject project = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_61) + project);
        }
        IJavaProject javaProject = rootJavaProject = JavaCore.create((IProject)project);
        IJavaProject[] requiredProjects = this.getRequiredProjects(javaProject, monitor);
        monitor.subTask(BuilderMessages.PreverificationBuilder_62);
        BuildInfo buildInfo = new BuildInfo(kind, args, javaProject);
        try {
            IJavaProject requiredProject;
            this.preverifyProject(buildInfo, monitor);
            IJavaProject[] iJavaProjectArray = requiredProjects;
            int n = requiredProjects.length;
            int n2 = 0;
            while (n2 < n) {
                requiredProject = iJavaProjectArray[n2];
                javaProject = requiredProject;
                if (javaProject != null) {
                    buildInfo.setCurrentJavaProject(javaProject);
                    this.preverifyProject(buildInfo, monitor);
                }
                ++n2;
            }
            if (buildInfo.areLibrariesPreverified()) {
                buildInfo.setCurrentJavaProject(rootJavaProject);
                this.preverifyLibraries(buildInfo, monitor);
                iJavaProjectArray = requiredProjects;
                n = requiredProjects.length;
                n2 = 0;
                while (n2 < n) {
                    javaProject = requiredProject = iJavaProjectArray[n2];
                    buildInfo.setCurrentJavaProject(javaProject);
                    this.preverifyLibraries(buildInfo, monitor);
                    ++n2;
                }
            }
            IProject[] interestingProjects = new IProject[requiredProjects.length];
            int i = 0;
            while (i < requiredProjects.length) {
                interestingProjects[i] = requiredProjects[i].getProject();
                ++i;
            }
            if (buildInfo.isPackageDirty()) {
                this.setResourcesAsDerived(buildInfo.getVerifiedClassesFolder(monitor), monitor);
                this.setResourcesAsDerived(buildInfo.getVerifiedLibsFolder(monitor), monitor);
            }
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_63) + project);
            }
            monitor.done();
            return interestingProjects;
        }
        catch (PreverifierNotFoundException preverifierNotFoundException) {
            this.createNoPreverifierFoundMarker();
            return null;
        }
    }

    protected void doClean(int kind, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_64) + project);
        }
        PreverificationBuilder.cleanProject(project, false, monitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_65) + project);
        }
    }

    protected String getBuilderId() {
        return "org.eclipse.mtj.core.preverifier";
    }

    protected void onStateExit(BuildStateMachine stateMachine, IProgressMonitor monitor) throws CoreException {
        super.onStateExit(stateMachine, monitor);
        BuildSpecManipulator manipulator = new BuildSpecManipulator(this.getMTJProject().getProject());
        if (!manipulator.hasBuilder("org.eclipse.mtj.core.packageBuilder")) {
            manipulator.addBuilderAfter("org.eclipse.mtj.core.preverifier", "org.eclipse.mtj.core.packageBuilder", null);
            manipulator.commitChanges(monitor);
        }
    }

    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_PREVERIFICATION;
    }

    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_PREVERIFICATION;
    }
}

