/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.text.IResourceFilter;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class SourceResourcesFilter
implements IResourceFilter {
    private static final String[] IGNORED_FILE_SUFFIXES = new String[]{"java", "jad"};
    private static final String[] IGNORED_PROJECT_FILES = new String[]{".classpath", ".project", ".mtj"};
    private static final String SETTINGS_FOLDER_NAME = ".settings";
    private IJavaProject javaProject;
    private Set<String> ignoredFileSuffixes;
    private Set<String> ignoredProjectFolders;
    private Set<String> ignoredProjectFiles;
    private Set<IPath> classpathLibs;

    public SourceResourcesFilter(IJavaProject javaProject) throws JavaModelException {
        this.javaProject = javaProject;
        this.initIgnoredProjectFiles();
        this.initIgnoredFileSuffixes();
        this.initIgnoredProjectFolders();
        this.initIgnoredClasspathLibs(javaProject);
    }

    public boolean shouldTraverseContainer(IContainer container) {
        return !this.isIgnoredProjectFolder(container);
    }

    public boolean shouldBeIncluded(IFile file) {
        boolean isIgnoredProjectFile;
        boolean bl = isIgnoredProjectFile = this.parentIsProject((IResource)file) && this.ignoredProjectFiles.contains(file.getName());
        return !isIgnoredProjectFile && !this.isIgnoredProjectFolder(file.getParent()) && !this.classpathLibs.contains(file.getFullPath()) && !this.ignoredFileSuffixes.contains(file.getFileExtension());
    }

    private void initIgnoredClasspathLibs(IJavaProject javaProject) throws JavaModelException {
        this.classpathLibs = new HashSet<IPath>();
        IClasspathEntry[] rawEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < rawEntries.length) {
            IClasspathEntry entry = rawEntries[i];
            this.addClasspathEntryIfLib(entry);
            ++i;
        }
    }

    private void initIgnoredProjectFolders() {
        this.ignoredProjectFolders = new HashSet<String>();
        this.ignoredProjectFolders.add(SETTINGS_FOLDER_NAME);
        this.ignoredProjectFolders.add(MTJCore.getDeploymentDirectoryName());
        this.ignoredProjectFolders.add(MTJCore.getVerifiedOutputDirectoryName());
    }

    private void initIgnoredFileSuffixes() {
        this.ignoredFileSuffixes = new HashSet<String>();
        int i = 0;
        while (i < IGNORED_FILE_SUFFIXES.length) {
            this.ignoredFileSuffixes.add(IGNORED_FILE_SUFFIXES[i]);
            ++i;
        }
    }

    private void initIgnoredProjectFiles() {
        this.ignoredProjectFiles = new HashSet<String>();
        int i = 0;
        while (i < IGNORED_PROJECT_FILES.length) {
            this.ignoredProjectFiles.add(IGNORED_PROJECT_FILES[i]);
            ++i;
        }
    }

    private boolean isIgnoredProjectFolder(IContainer container) {
        return this.parentIsProject((IResource)container) && this.ignoredProjectFolders.contains(container.getName());
    }

    private boolean parentIsProject(IResource resource) {
        return resource.getParent().getType() == 4;
    }

    private void addClasspathEntryIfLib(IClasspathEntry entry) throws JavaModelException {
        switch (entry.getEntryKind()) {
            case 1: {
                this.classpathLibs.add(entry.getPath());
                break;
            }
            case 5: {
                IPath path = entry.getPath();
                if (path.segment(0).equals("org.elipse.mtj.JavaMEContainer")) break;
                IClasspathContainer cpContainer = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.javaProject);
                if (cpContainer != null) {
                    IClasspathEntry[] entries = cpContainer.getClasspathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        this.addClasspathEntryIfLib(entries[i]);
                        ++i;
                    }
                    break;
                }
                MTJLogger.log(4, "Unable to resolve classpath container entry " + path);
                break;
            }
            case 4: {
                IClasspathEntry entry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                if (entry2 == null) break;
                this.addClasspathEntryIfLib(entry2);
                break;
            }
        }
    }
}

