/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.MTJCoreErrors;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.sign.Base64EncDec;
import org.eclipse.mtj.internal.core.build.sign.KeyChainSet;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.osgi.util.NLS;

public class JadSignature
implements IJadSignature {
    private KeyChainSet m_keyChainSet;
    private byte[] m_buffer;
    private String m_strJarSignature;
    private String[] m_strCertificates;
    private static final int BUFFER_SIZE = 4096;

    public JadSignature() {
    }

    public JadSignature(KeyChainSet kcs) {
        this.setKeyChainSet(kcs);
    }

    public void setKeyChainSet(KeyChainSet kcs) {
        this.m_keyChainSet = kcs;
    }

    public KeyChainSet getKeyChainSet() {
        return this.m_keyChainSet;
    }

    public String getJarSignatureString() {
        return this.m_strJarSignature;
    }

    public String[] getCertificateStrings() {
        return this.m_strCertificates;
    }

    public void computeSignature(File jarFile) throws CoreException {
        block23: {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                try {
                    fis = new FileInputStream(jarFile);
                    bis = new BufferedInputStream(fis);
                    this.computeSignature(bis);
                }
                catch (Exception e) {
                    MTJStatusHandler.throwCoreException(4, 9999, e);
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void computeSignature(InputStream jarStream) throws CoreException, IOException {
        this.checkKeyChainSet();
        X509Certificate[] chain = this.m_keyChainSet.getCertificateChain();
        PrivateKey key = this.m_keyChainSet.getKey();
        if (this.m_buffer == null) {
            this.m_buffer = new byte[4096];
        }
        try {
            int nRead;
            this.m_strCertificates = new String[chain.length];
            int i = 0;
            while (i < chain.length) {
                byte[] certBytes = chain[i].getEncoded();
                this.m_strCertificates[i] = Base64EncDec.encode(certBytes);
                ++i;
            }
            Signature signature = this.m_keyChainSet.getProvider() == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", this.m_keyChainSet.getProvider());
            signature.initSign(key);
            while ((nRead = jarStream.read(this.m_buffer)) >= 0) {
                signature.update(this.m_buffer, 0, nRead);
            }
            byte[] sigBytes = signature.sign();
            this.m_strJarSignature = Base64EncDec.encode(sigBytes);
        }
        catch (NoSuchAlgorithmException nsae) {
            MTJCoreErrors.throwCoreExceptionError(10012, Messages.MTJCoreError_10012, nsae);
        }
        catch (NoSuchProviderException nspe) {
            MTJCoreErrors.throwCoreExceptionError(10003, Messages.MTJCoreError_10003, nspe);
        }
        catch (InvalidKeyException ike) {
            MTJCoreErrors.throwCoreExceptionError(10011, Messages.MTJCoreError_10011, ike);
        }
        catch (SignatureException se) {
            MTJCoreErrors.throwCoreExceptionError(10013, Messages.MTJCoreError_10013, se);
        }
        catch (CertificateEncodingException cee) {
            MTJCoreErrors.throwCoreExceptionError(10014, Messages.MTJCoreError_10014, cee);
        }
    }

    public void checkKeyChainSet() throws CoreException {
        PrivateKey key;
        String strKeyAlgorithm;
        X509Certificate[] chain;
        if (this.m_keyChainSet == null) {
            MTJCoreErrors.throwCoreExceptionError(90001, NLS.bind((String)Messages.MTJCoreError_Default, (Object)90001));
        }
        if ((chain = this.m_keyChainSet.getCertificateChain()) == null) {
            MTJCoreErrors.throwCoreExceptionError(10010, Messages.MTJCoreError_10010);
        }
        if (!"RSA".equals(strKeyAlgorithm = (key = this.m_keyChainSet.getKey()).getAlgorithm())) {
            MTJCoreErrors.throwCoreExceptionError(10008, Messages.MTJCoreError_10008);
        }
    }
}

