/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;

public class SignatureProperties
implements ISignatureProperties {
    private boolean m_bSignProject;
    private boolean m_bProjectSpecific;
    private String m_strKeyStoreDisplayPath;
    private String m_strKeyAlias;
    private int m_nPasswordStorageMethod;
    private String m_strKeyStorePassword;
    private String m_strKeyPassword;
    private String m_strKeyStoreType;
    private String m_strKeyStoreProvider;

    public void copy(ISignatureProperties other) {
        this.m_bSignProject = other.isSignProject();
        this.m_bProjectSpecific = other.isProjectSpecific();
        this.m_strKeyStoreDisplayPath = other.getKeyStoreDisplayPath();
        this.m_strKeyAlias = other.getKeyAlias();
        this.m_nPasswordStorageMethod = other.getPasswordStorageMethod();
        this.m_strKeyStorePassword = other.getKeyStorePassword();
        this.m_strKeyPassword = other.getKeyPassword();
        this.m_strKeyStoreType = other.getKeyStoreType();
        this.m_strKeyStoreProvider = other.getKeyStoreProvider();
    }

    public void clear() {
        this.m_bProjectSpecific = false;
        this.m_bSignProject = false;
        this.m_strKeyStoreDisplayPath = null;
        this.m_strKeyAlias = null;
        this.m_nPasswordStorageMethod = 0;
        this.m_strKeyStorePassword = null;
        this.m_strKeyPassword = null;
        this.m_strKeyStoreType = null;
        this.m_strKeyStoreProvider = null;
    }

    public boolean isSignProject() {
        return this.m_bSignProject;
    }

    public boolean isProjectSpecific() {
        return this.m_bProjectSpecific;
    }

    public void setSignProject(boolean bValue) {
        this.m_bSignProject = bValue;
    }

    public int getPasswordStorageMethod() {
        return this.m_nPasswordStorageMethod;
    }

    public void setPasswordStorageMethod(int nMethod) {
        this.m_nPasswordStorageMethod = nMethod;
    }

    public String getKeyStoreType() {
        return this.m_strKeyStoreType;
    }

    public void setKeyStoreType(String strValue) {
        this.m_strKeyStoreType = strValue != null && strValue.length() > 0 ? strValue : null;
    }

    public String getKeyStoreProvider() {
        return this.m_strKeyStoreProvider;
    }

    public void setKeyStoreProvider(String strValue) {
        this.m_strKeyStoreProvider = strValue != null && strValue.length() > 0 ? strValue : null;
    }

    public String getKeyStorePassword() {
        return this.m_strKeyStorePassword;
    }

    public void setKeyStorePassword(String strValue) {
        this.m_strKeyStorePassword = strValue != null && strValue.length() > 0 ? strValue : null;
    }

    public String getKeyAlias() {
        return this.m_strKeyAlias;
    }

    public void setKeyAlias(String strValue) {
        this.m_strKeyAlias = strValue != null && strValue.length() > 0 ? strValue : null;
    }

    public String getKeyPassword() {
        return this.m_strKeyPassword;
    }

    public void setKeyPassword(String strValue) {
        this.m_strKeyPassword = strValue != null && strValue.length() > 0 ? strValue : null;
    }

    public String getKeyStoreDisplayPath() {
        return this.m_strKeyStoreDisplayPath;
    }

    public void setKeyStoreDisplayPath(String strValue) {
        this.m_strKeyStoreDisplayPath = strValue != null && strValue.length() > 0 ? strValue : null;
    }

    public String getAbsoluteKeyStorePath(IProject project) throws CoreException {
        if (this.isKeyStorePathExternal()) {
            return this.m_strKeyStoreDisplayPath;
        }
        return SignatureProperties.toAbsolute(this.m_strKeyStoreDisplayPath, project);
    }

    public boolean isKeyStorePathExternal() {
        if (this.m_strKeyStoreDisplayPath == null) {
            return true;
        }
        if (this.m_strKeyStoreDisplayPath.length() < "$/".length()) {
            return true;
        }
        return !"$/".equals(this.m_strKeyStoreDisplayPath.substring(0, "$/".length()));
    }

    public void setProjectSpecific(boolean value) {
        this.m_bProjectSpecific = value;
    }

    public static String toAbsolute(String path, IProject project) throws CoreException {
        String relativePath = path.substring("$/".length());
        IPath projectPath = project.getLocation();
        IPath absolutePath = projectPath.append(relativePath);
        return absolutePath.toString();
    }

    public static String toRelative(String path) {
        path = path.charAt(0) == '/' ? "$/" + path.substring(1) : "$/" + path;
        return path;
    }
}

