/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.model;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.internal.core.externallibrary.classpath.ClasspathAccessRule;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.externallibrary.model.Visibility;
import org.eclipse.mtj.internal.core.externallibrary.model.licence.LicenceInfo;
import org.eclipse.mtj.internal.core.externallibrary.model.security.PermissionList;
import org.eclipse.mtj.internal.core.externallibrary.model.security.ProtectionDomain;
import org.eclipse.mtj.internal.core.externallibrary.model.security.SecurityInfo;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MidletExternalLibrary
implements IExternalLibrary {
    private static final String EP_ATTRIB_ACCESSRULE_KIND = "kind";
    private static final String EP_ATTRIB_ACCESSRULE_PATTERN = "pattern";
    private static final String EP_ATTRIB_CLASSPATHENTRY_JARFILE = "jarFile";
    private static final String EP_ATTRIB_CLASSPATHENTRY_JAVADOCPATH = "javadocPath";
    private static final String EP_ATTRIB_CLASSPATHENTRY_SRCPATH = "srcPath";
    private static final String EP_ATTRIB_LIBRARY_DESCRIPTION = "description";
    private static final String EP_ATTRIB_LIBRARY_NAME = "name";
    private static final String EP_ATTRIB_LIBRARY_VERSION = "version";
    private static final String EP_ATTRIB_LIBRARY_VISIBILITY = "visibility";
    private static final String EP_ATTRIB_LICENSE_NAME = "name";
    private static final String EP_ATTRIB_LICENSE_URL = "url";
    private static final String EP_ATTRIB_SECURITY_PD = "ProtectionDomain";
    private static final String EP_ATTRIB_SECURITY_PERMISSIONS = "Premissions";
    private static final String EP_ELEMENT_ACCESSRULE = "AccessRule";
    private static final String EP_ELEMENT_CLASSPATHENTRY = "ClasspathEntry";
    private static final String EP_ELEMENT_LICENSE = "License";
    private static final String EP_ELEMENT_SECURITY = "Security";
    private static final String FILE_PROTOCOL = "file:/";
    private List<IClasspathEntry> classpathEntryList;
    private String description;
    private String identifier;
    private LicenceInfo licence;
    private String name;
    private SecurityInfo security;
    private Version version;
    private Visibility visibility;

    public MidletExternalLibrary(IConfigurationElement configurationElement) throws IllegalArgumentException {
        IConfigurationElement[] ClasspathEntries;
        String extImplAbsolutePath = this.getBundleAbsolutePath(configurationElement.getNamespaceIdentifier());
        this.classpathEntryList = new ArrayList<IClasspathEntry>();
        this.name = configurationElement.getAttribute("name");
        if (this.name == null) {
            throw new IllegalArgumentException("No library name defined.");
        }
        this.visibility = Visibility.getFromString(configurationElement.getAttribute(EP_ATTRIB_LIBRARY_VISIBILITY));
        if (this.visibility == Visibility.INVALID) {
            this.visibility = Visibility.PUBLIC;
        }
        String versionString = configurationElement.getAttribute(EP_ATTRIB_LIBRARY_VERSION);
        try {
            this.version = new Version(versionString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The version for " + this.name + " is improperly formatted.", e);
        }
        this.description = configurationElement.getAttribute(EP_ATTRIB_LIBRARY_DESCRIPTION);
        this.identifier = String.valueOf(this.name.replace(" ", "_")) + "_" + this.version.toString();
        IConfigurationElement[] iConfigurationElementArray = ClasspathEntries = configurationElement.getChildren(EP_ELEMENT_CLASSPATHENTRY);
        int n = ClasspathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement classpathEntry = iConfigurationElementArray[n2];
            Path jarPath = new Path(String.valueOf(extImplAbsolutePath) + File.separator + classpathEntry.getAttribute(EP_ATTRIB_CLASSPATHENTRY_JARFILE));
            String sourceFolder = classpathEntry.getAttribute(EP_ATTRIB_CLASSPATHENTRY_SRCPATH);
            Path srcPath = null;
            if (sourceFolder != null) {
                srcPath = new Path(String.valueOf(extImplAbsolutePath) + File.separator + sourceFolder);
            }
            String javadocFolder = classpathEntry.getAttribute(EP_ATTRIB_CLASSPATHENTRY_JAVADOCPATH);
            IClasspathAttribute[] extraAttributes = null;
            if (javadocFolder != null) {
                Path javadocPath = new Path(String.valueOf(extImplAbsolutePath) + File.separator + javadocFolder);
                extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocPath.toOSString())};
            } else {
                extraAttributes = new IClasspathAttribute[]{};
            }
            IConfigurationElement[] accessRulesElements = classpathEntry.getChildren(EP_ELEMENT_ACCESSRULE);
            ArrayList<IAccessRule> accessRules = new ArrayList<IAccessRule>();
            IConfigurationElement[] iConfigurationElementArray2 = accessRulesElements;
            int n3 = accessRulesElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement accessRule = iConfigurationElementArray2[n4];
                ClasspathAccessRule rule = new ClasspathAccessRule((IPath)new Path(accessRule.getAttribute(EP_ATTRIB_ACCESSRULE_PATTERN)), accessRule.getAttribute(EP_ATTRIB_ACCESSRULE_KIND));
                accessRules.add(JavaCore.newAccessRule((IPath)rule.getPattern(), (int)rule.getKind()));
                ++n4;
            }
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null, (IAccessRule[])accessRules.toArray(new IAccessRule[0]), (IClasspathAttribute[])extraAttributes, (boolean)true);
            this.classpathEntryList.add(entry);
            ++n2;
        }
        IConfigurationElement[] licenceCE = configurationElement.getChildren(EP_ELEMENT_LICENSE);
        try {
            URI uri = null;
            try {
                uri = URI.create(licenceCE[0].getAttribute(EP_ATTRIB_LICENSE_URL));
            }
            catch (Throwable throwable) {}
            this.licence = new LicenceInfo(licenceCE[0].getAttribute("name"), uri);
        }
        catch (Throwable e) {
            MTJLogger.log(2, "No Lincense information available for " + this.name, e);
        }
        IConfigurationElement[] securityCE = configurationElement.getChildren(EP_ELEMENT_SECURITY);
        ProtectionDomain domain = null;
        try {
            domain = new ProtectionDomain(securityCE[0].getAttribute(EP_ATTRIB_SECURITY_PD));
        }
        catch (Throwable e) {
            domain = new ProtectionDomain(ProtectionDomain.ProtectionDomainType.UNTRUSTED);
            MTJLogger.log(2, "No Protection Domain information available for " + this.name + ". the Untrusted domain will be used.", e);
        }
        PermissionList permissionList = null;
        try {
            permissionList = new PermissionList(securityCE[0].getAttribute(EP_ATTRIB_SECURITY_PERMISSIONS));
        }
        catch (Throwable throwable) {
            permissionList = PermissionList.EMPTY;
            MTJLogger.log(2, "No permission information available for " + this.name, null);
        }
        this.security = new SecurityInfo(domain, permissionList);
    }

    public MidletExternalLibrary(String identifier, String name, String description, Visibility visibility, Version version, LicenceInfo licence, SecurityInfo security) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("No library name defined.");
        }
        if (version == null) {
            throw new IllegalArgumentException("No version was provided for " + name);
        }
        if (visibility == null) {
            throw new IllegalArgumentException("No visibility was provided for " + name);
        }
        this.name = name;
        this.visibility = visibility;
        this.version = version;
        this.identifier = identifier;
        this.description = description;
        this.licence = licence;
        this.classpathEntryList = new ArrayList<IClasspathEntry>();
        this.security = security;
    }

    @Override
    public void addClasspathEntry(IClasspathEntry libraryItem) {
        this.classpathEntryList.add(libraryItem);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MidletExternalLibrary other = (MidletExternalLibrary)obj;
        if (this.classpathEntryList == null ? other.classpathEntryList != null : !this.classpathEntryList.equals(other.classpathEntryList)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.licence == null ? other.licence != null : !this.licence.equals(other.licence)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals((Object)other.version)) {
            return false;
        }
        return !(this.visibility == null ? other.visibility != null : !this.visibility.equals((Object)other.visibility));
    }

    @Override
    public List<IClasspathEntry> getClasspathEntryList() {
        return Collections.unmodifiableList(this.classpathEntryList);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public LicenceInfo getLicence() {
        return this.licence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SecurityInfo getSecurity() {
        return this.security;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.classpathEntryList == null ? 0 : this.classpathEntryList.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.licence == null ? 0 : this.licence.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.visibility == null ? 0 : this.visibility.hashCode());
        return result;
    }

    @Override
    public void removeClasspathEntry(IClasspathEntry libraryItem) {
        this.classpathEntryList.remove(libraryItem);
    }

    @Override
    public void setClasspathEntryList(List<IClasspathEntry> libraryItemList) {
        this.classpathEntryList = libraryItemList;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    private String getBundleAbsolutePath(String bundleNamespaceIdentifier) {
        String absolutePath = new String();
        URL entry = Platform.getBundle((String)bundleNamespaceIdentifier).getEntry("/");
        String bundleLocation = "";
        try {
            bundleLocation = FileLocator.toFileURL((URL)entry).getPath();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        URL bundleUrl = null;
        try {
            bundleUrl = new File(bundleLocation).toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (bundleUrl != null && (absolutePath = bundleUrl.getFile()).startsWith(FILE_PROTOCOL)) {
            absolutePath = absolutePath.substring(FILE_PROTOCOL.length() + 1);
        }
        return absolutePath;
    }

    public static String getMidletLibraryName(IConfigurationElement configurationElement) {
        String midletLibraryName = configurationElement.getAttribute("name");
        return midletLibraryName;
    }
}

