/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.l10n;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.l10n.Messages;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class L10nBuilder
extends MTJIncrementalProjectBuilder {
    protected IProject[] doBuild(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            IResourceDelta delta = this.getDelta(project);
            if (delta != null) {
                if (this.hasLocalizationDataChanged(project, delta)) {
                    this.doBuild(project, monitor);
                }
            } else {
                this.doBuild(project, monitor);
            }
        }
        catch (FileNotFoundException e) {
            MTJStatusHandler.throwCoreException(4, 0, e);
        }
        return null;
    }

    protected void doClean(int kind, IProgressMonitor monitor) throws CoreException {
        IPackageFragmentRoot[] roots;
        monitor.subTask(Messages.L10nBuilder_clean_CleaningOldProperties);
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                root.getCorrespondingResource().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        String name = resource.getName();
                        if (name.startsWith("messages") && name.endsWith(".properties")) {
                            resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        return true;
                    }
                });
            }
            ++n2;
        }
    }

    protected String getBuilderId() {
        return "org.eclipse.mtj.core.l10nBuilder";
    }

    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_LOCALIZATION;
    }

    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_LOCALIZATION;
    }

    private boolean hasLocalizationDataChanged(IProject project, IResourceDelta delta) throws FileNotFoundException {
        boolean result = false;
        IFile locationsXml = project.getFile("Localization Data");
        if (locationsXml.exists()) {
            IResourceDelta xmlDelta = delta.findMember(locationsXml.getProjectRelativePath());
            if (xmlDelta != null) {
                switch (xmlDelta.getKind()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        result = true;
                    }
                }
            }
        } else {
            throw new FileNotFoundException(Messages.L10nBuilder_LocalizationDataDoesNotExist);
        }
        return result;
    }

    private void doBuild(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            L10nModel model = L10nApi.loadL10nModel(project);
            if (model.isValid()) {
                monitor.subTask(Messages.L10nBuilder_BuildingLocalizationData);
                L10nLocales locales = model.getLocales();
                IFolder propertiesFolder = project.getFolder(locales.getDestination());
                if (!propertiesFolder.exists()) {
                    propertiesFolder.create(true, true, monitor);
                }
                monitor.subTask(Messages.L10nBuilder_generatingProperties);
                this.createProperties(project, locales, propertiesFolder, monitor);
                IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
                IPackageFragment[] packages = javaProject.getPackageFragments();
                int i = 0;
                while (i < packages.length) {
                    if (packages[i].getElementName().equals(locales.getPackage())) {
                        monitor.subTask(Messages.L10nBuilder_updatingConstants);
                        String code = L10nApi.buildL10nConstantsClass(project, packages[i]);
                        packages[i].createCompilationUnit("L10nConstants.java", code, true, monitor);
                        break;
                    }
                    ++i;
                }
                IFolder folder = project.getFolder((IPath)new Path(locales.getDestination()));
                if (folder.exists()) {
                    folder.refreshLocal(1, monitor);
                }
            } else {
                MTJLogger.log(4, Messages.L10nBuilder_InvalidModel);
            }
        }
        catch (Exception e) {
            MTJStatusHandler.throwCoreException(4, 0, e);
        }
    }

    private void createProperties(IProject project, L10nLocales locales, IFolder propertiesFolder, IProgressMonitor monitor) throws IOException {
        monitor.subTask(Messages.L10nBuilder_ProcessingLocalizationData);
        List<IDocumentElementNode> nodes = locales.getChildren();
        for (IDocumentElementNode localeElement : nodes) {
            L10nLocale locale = (L10nLocale)localeElement;
            IFile file = this.writePropertyFile(locale, propertiesFolder, monitor);
            IMTJProject suiteProject = MidletSuiteFactory.getMidletSuiteProject(project.getName());
            MTJBuildProperties properties = MTJBuildProperties.getBuildProperties(suiteProject);
            for (MTJRuntime runtime : suiteProject.getRuntimeList()) {
                properties.includeResource((IResource)file, runtime);
            }
        }
    }

    private IFile writePropertyFile(L10nLocale locale, IFolder propertiesFolder, IProgressMonitor monitor) throws IOException {
        monitor.subTask(NLS.bind((String)"Writing Localization Data for locale {0}", (Object)locale.getLocaleName()));
        if (!propertiesFolder.exists()) {
            throw new FileNotFoundException(Messages.L10nBuilder_PackageFolderNotFound);
        }
        ByteArrayInputStream stream = null;
        IFile file = null;
        String name = null;
        name = locale.getLocaleName() != null ? NLS.bind((String)"messages_{0}.properties", (Object)locale.getLocaleName()) : "messages.properties";
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                IDocumentElementNode[] nodes = locale.getChildNodes();
                int i = 0;
                while (i < nodes.length) {
                    L10nEntry entry = (L10nEntry)nodes[i];
                    buffer.append(entry.getKey().toUpperCase());
                    buffer.append("=");
                    buffer.append(entry.getValue());
                    buffer.append("\n");
                    ++i;
                }
                stream = new ByteArrayInputStream(buffer.toString().getBytes());
                file = propertiesFolder.getFile(name);
                if (file.exists()) {
                    file.setContents((InputStream)stream, 1, monitor);
                } else {
                    file.create((InputStream)stream, true, monitor);
                }
            }
            catch (Exception exception) {
                throw new IOException(NLS.bind((String)Messages.L10nBuilder_ErrorWritingProperty, (Object)locale.getLocaleName()));
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return file;
    }
}

