/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching;

import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.mtj.internal.core.launching.StackTraceParser;
import org.eclipse.mtj.internal.core.launching.StackTraceParserException;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.osgi.util.NLS;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetedStackTraceParser
extends StackTraceParser {
    public OffsetedStackTraceParser(IJavaProject _project) {
        super(_project);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Stack<StackTraceEntry> parseStackTrace(Stack<StackTraceEntry> _stack) throws StackTraceParserException {
        linedStack = new Stack<StackTraceEntry>();
        stack = new Stack<StackTraceEntry>();
        stack.addAll(_stack);
        caller = null;
        callee = null;
        method = null;
        block2: while (!stack.isEmpty() && method == null) {
            caller = (StackTraceEntry)stack.pop();
            method = this.getStackBaseMethod(caller);
            if (method != null) ** GOTO lbl28
            continue;
lbl-1000:
            // 1 sources

            {
                try {
                    callee = (StackTraceEntry)stack.pop();
                    method = this.getCalleeMethodNode(method, caller, callee);
                    linedStack.push(caller);
                    caller = callee;
                    continue;
                }
                catch (StackTraceParserException v0) {
                    if (caller.getLine() != -2147483648) {
                        linedStack.push(caller);
                    }
                    stack.push(callee);
                    method = null;
                    continue block2;
                }
lbl28:
                // 2 sources

                ** while (!stack.isEmpty())
            }
lbl29:
            // 1 sources

        }
        if (caller != null && method != null) {
            line = this.getStackTopCalleeLine(method, caller);
            caller.setSourcePath(this.getSourceFile(caller.getClassName()));
            caller.setLine(line);
            linedStack.push(caller);
        }
        return linedStack;
    }

    private int getStackTopCalleeLine(MethodNode callerMethod, StackTraceEntry caller) {
        int line = Integer.MIN_VALUE;
        AbstractInsnNode[] instructions = callerMethod.instructions.toArray();
        int i = 0;
        while (i < instructions.length) {
            if (instructions[i] instanceof LineNumberNode) {
                LineNumberNode lineNumberNode = (LineNumberNode)instructions[i];
                int offset = lineNumberNode.start.getLabel().getOffset();
                if (offset >= caller.getOffset()) break;
                line = lineNumberNode.line;
            }
            ++i;
        }
        return line;
    }

    private MethodNode getCalleeMethodNode(MethodNode callerMethod, StackTraceEntry caller, StackTraceEntry callee) throws StackTraceParserException {
        MethodInsnNode targetMethod = null;
        int line = Integer.MIN_VALUE;
        AbstractInsnNode[] instructions = callerMethod.instructions.toArray();
        int i = 0;
        while (i < instructions.length) {
            if (instructions[i] instanceof LineNumberNode) {
                LineNumberNode lineNumberNode = (LineNumberNode)instructions[i];
                int offset = lineNumberNode.start.getLabel().getOffset();
                if (offset >= caller.getOffset()) break;
                line = lineNumberNode.line;
            } else if (instructions[i] instanceof MethodInsnNode) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)instructions[i];
                if (methodInsnNode.owner.equals(callee.getClassName()) && methodInsnNode.name.equals(callee.getMethodName())) {
                    targetMethod = methodInsnNode;
                }
            }
            ++i;
        }
        caller.setSourcePath(this.getSourceFile(caller.getClassName()));
        caller.setLine(line);
        if (targetMethod == null) {
            throw new StackTraceParserException(Messages.OffsetedStackTraceParser_getClassNode_unableToRealizeTargetMethod);
        }
        MethodNode result = this.getMethodNode(targetMethod);
        if (result == null) {
            throw new StackTraceParserException(Messages.OffsetedStackTraceParser_getClassNode_unableToRealizeMethodNode);
        }
        return result;
    }

    private MethodNode getMethodNode(MethodInsnNode methodInsnNode) throws StackTraceParserException {
        MethodNode methodNode = null;
        ClassNode classNode = this.getClassNode(methodInsnNode.owner);
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            if (!method.name.equals(methodInsnNode.name) || !method.desc.equals(methodInsnNode.desc)) continue;
            methodNode = method;
            break;
        }
        return methodNode;
    }

    private MethodNode getStackBaseMethod(StackTraceEntry entry) throws StackTraceParserException {
        MethodNode result = null;
        ClassNode clazz = null;
        try {
            clazz = this.getClassNode(entry.getClassName());
        }
        catch (StackTraceParserException stackTraceParserException) {
            return null;
        }
        List methods = clazz.methods;
        for (MethodNode methodNode : methods) {
            if (!methodNode.name.equals(entry.getMethodName())) continue;
            if (result == null) {
                result = methodNode;
                continue;
            }
            return null;
        }
        if (result == null) {
            throw new StackTraceParserException(Messages.bind((String)Messages.StackTraceParser_getStackBaseMethod_method_not_found, (Object[])new String[]{entry.getClassName(), entry.getMethodName()}));
        }
        return result;
    }

    private ClassNode getClassNode(String className) throws StackTraceParserException {
        ClassNode classNode = new ClassNode();
        try {
            IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(this.project);
            if (midletSuiteProject == null) {
                String message = NLS.bind((String)Messages.OffsetedStackTraceParser_getClassNode_unableToRealizeMidletSuiteProject, (Object)this.project.getProject().getName());
                throw new StackTraceParserException(message);
            }
            IFolder vFolder = midletSuiteProject.getVerifiedClassesOutputFolder(null);
            if (!vFolder.exists()) {
                throw new StackTraceParserException(Messages.OffsetedStackTraceParser_getClassNode_verifiedFolderDoesNotExist);
            }
            String classPath = NLS.bind((String)"{0}.class", (Object)className.replace(".", "/"));
            IFile classFile = vFolder.getFile(classPath);
            if (!classFile.exists()) {
                String message = NLS.bind((String)Messages.OffsetedStackTraceParser_getClassNode_unableToFindClassFile, (Object)className);
                throw new StackTraceParserException(message);
            }
            ClassReader classReader = new ClassReader(classFile.getContents());
            classReader.accept((ClassVisitor)classNode, 0);
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (IOException e) {
            throw new StackTraceParserException(e);
        }
        catch (JavaModelException e) {
            throw new StackTraceParserException(e);
        }
        catch (CoreException e) {
            throw new StackTraceParserException(e);
        }
        return classNode;
    }
}

