/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceEntry {
    private static final String AT = "at ";
    private List<IRegion> regions;
    private String methodName;
    private String className;
    private File sourceFile;
    private int offset;
    private int line = Integer.MIN_VALUE;

    public StackTraceEntry(String trace) {
        if (Pattern.matches("(\tat .+[(].*[.java][:]\\d+[)])", trace)) {
            this.parseLineWithLine(trace);
        } else if (Pattern.matches("(\tat .+[(][+]\\d+[)])", trace)) {
            this.parseLineWithOffset(trace);
        } else if (Pattern.matches("(\\s[-]\\s.+[,]\\s(bci=)\\d+)", trace)) {
            this.parseLineWithBci(trace);
        } else {
            throw new IllegalArgumentException("Invalid stack trace format.");
        }
    }

    private void parseLineWithOffset(String trace) {
        int atIndex = trace.indexOf(AT);
        trace = trace.substring(atIndex += AT.length());
        int dotIndex = trace.lastIndexOf(".");
        int lprIndex = trace.lastIndexOf("(");
        int rprIndex = trace.lastIndexOf(")");
        this.className = trace.substring(0, dotIndex);
        this.methodName = trace.substring(++dotIndex, lprIndex++);
        this.offset = Integer.parseInt(trace.substring(++lprIndex, rprIndex));
    }

    private void parseLineWithLine(String trace) {
        int atIndex = trace.indexOf(AT);
        trace = trace.substring(atIndex += AT.length());
        int lprIndex = trace.lastIndexOf("(");
        int rprIndex = trace.lastIndexOf(")");
        int colIndex = trace.lastIndexOf(":");
        String part1 = trace.substring(0, lprIndex);
        int dotIndex = part1.lastIndexOf(".");
        this.className = part1.substring(0, dotIndex);
        this.methodName = part1.substring(++dotIndex);
        this.line = Integer.parseInt(trace.substring(++colIndex, rprIndex));
    }

    private void parseLineWithBci(String trace) {
        trace = trace.substring(3);
        int dotIndex = trace.lastIndexOf(".");
        int lprIndex = trace.lastIndexOf("(");
        int eqlIndex = trace.lastIndexOf("=");
        this.className = trace.substring(0, dotIndex);
        this.methodName = trace.substring(++dotIndex, lprIndex);
        this.offset = Integer.parseInt(trace.substring(++eqlIndex));
    }

    public synchronized void addRegion(IRegion region) {
        if (this.regions == null) {
            this.regions = new LinkedList<IRegion>();
        }
        this.regions.add(region);
    }

    public List<IRegion> getRegions() {
        return this.regions;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className.replace(".", "/");
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.className);
        buffer.append(".");
        buffer.append(this.methodName);
        buffer.append("(");
        buffer.append(this.className);
        buffer.append(".java:");
        buffer.append(this.line);
        buffer.append(")");
        return buffer.toString();
    }

    public void setSourcePath(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getJavaFile() {
        return this.sourceFile;
    }
}

