/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.packaging.midp;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.sign.SignatureUtils;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class DeployedJADWriter {
    private IMidletSuiteProject midletSuite;
    private File deploymentFolder;
    private File deployedJarFile;

    public DeployedJADWriter(IMidletSuiteProject midletSuite, IFolder deploymentFolder, File deployedJar) {
        this(midletSuite, deploymentFolder.getLocation().toFile(), deployedJar);
    }

    public DeployedJADWriter(IMidletSuiteProject midletSuite, File deploymentFolder, File deployedJar) {
        this.midletSuite = midletSuite;
        this.deploymentFolder = deploymentFolder;
        this.deployedJarFile = deployedJar;
    }

    public void writeDeployedJAD(boolean incrementalBuild, IProgressMonitor monitor) throws IOException, CoreException {
        IJadSignature signatureObject;
        IApplicationDescriptor appDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties jadProperties = (ColonDelimitedProperties)appDescriptor.getManifestProperties();
        jadProperties.setProperty("MIDlet-Jar-Size", Long.valueOf(this.deployedJarFile.length()).toString());
        if (incrementalBuild) {
            jadProperties.setProperty("MIDlet-Jar-URL", this.deployedJarFile.getName());
        }
        this.writeJad(appDescriptor);
        if (!incrementalBuild && (signatureObject = SignatureUtils.getSignatureObject(this.midletSuite)) != null) {
            BuildStateMachine stateMachine = BuildStateMachine.getInstance(this.midletSuite);
            stateMachine.changeState(MTJBuildState.PRE_SIGNING, monitor);
            this.signJad(signatureObject, this.deployedJarFile, jadProperties);
            this.writeJad(appDescriptor);
            stateMachine.changeState(MTJBuildState.POST_SIGNING, monitor);
        }
    }

    private void signJad(IJadSignature signatureObject, File deployedJarFile, ColonDelimitedProperties jadProperties) throws CoreException {
        signatureObject.computeSignature(deployedJarFile);
        jadProperties.setProperty("MIDlet-Jar-RSA-SHA1", signatureObject.getJarSignatureString());
        String[] certificates = signatureObject.getCertificateStrings();
        int i = 1;
        while (i <= certificates.length) {
            jadProperties.setProperty("MIDlet-Certificate-1-" + i, certificates[i - 1]);
            ++i;
        }
    }

    private void writeJad(IApplicationDescriptor appDescriptor) throws IOException {
        String jadName = this.midletSuite.getJadFileName();
        if (jadName != null) {
            File deployedJadFile = new File(this.deploymentFolder, jadName);
            if (!deployedJadFile.exists()) {
                deployedJadFile.createNewFile();
            }
            appDescriptor.store(deployedJadFile);
        } else {
            MTJLogger.log(4, Messages.DeployedJADWriter_unableToResolveJadName);
        }
    }
}

