/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
implements IApplicationDescriptor {
    public static final String MIDLET_PREFIX = "MIDlet-";
    private ColonDelimitedProperties manifestProperties;
    private List<IMidletDefinition> midletDefinitions;
    private File sourceFile;

    public ApplicationDescriptor(File jadFile) throws IOException {
        this.sourceFile = jadFile;
        this.midletDefinitions = new ArrayList<IMidletDefinition>();
        this.parseDescriptor(jadFile);
    }

    @Override
    public void addMidletDefinition(IMidletDefinition midletDefinition) {
        this.midletDefinitions.add(midletDefinition);
    }

    @Override
    public Version getConfigurationSpecificationVersion() throws CoreException {
        String[] components;
        Version version = null;
        String configIdentifier = this.manifestProperties.getProperty("MicroEdition-Configuration");
        if (configIdentifier != null && (components = configIdentifier.split("-")).length == 2) {
            version = new Version(components[1]);
        }
        if (version == null) {
            version = new Version("1.0");
        }
        return version;
    }

    @Override
    public ColonDelimitedProperties getManifestProperties() {
        return this.manifestProperties;
    }

    @Override
    public String getMicroEditionConfiguration() {
        String configuration = null;
        if (this.manifestProperties != null) {
            configuration = this.manifestProperties.getProperty("MicroEdition-Configuration");
        }
        return configuration;
    }

    @Override
    public String getMicroEditionProfile() {
        String profile = null;
        if (this.manifestProperties != null) {
            profile = this.manifestProperties.getProperty("MicroEdition-Profile");
        }
        return profile;
    }

    @Override
    public int getMidletCount() {
        return this.midletDefinitions.size();
    }

    @Override
    public String getMIDletDataSize() {
        String datasize = null;
        if (this.manifestProperties != null) {
            datasize = this.manifestProperties.getProperty("MIDlet-Data-Size");
        }
        return datasize;
    }

    @Override
    public List<IMidletDefinition> getMidletDefinitions() {
        return this.midletDefinitions;
    }

    @Override
    public String getMIDletDeleteConfirm() {
        String message = null;
        if (this.manifestProperties != null) {
            message = this.manifestProperties.getProperty("MIDlet-Delete-Confirm");
        }
        return message;
    }

    @Override
    public String getMIDletDeleteNotify() {
        String url = null;
        if (this.manifestProperties != null) {
            url = this.manifestProperties.getProperty("MIDlet-Delete-Notify");
        }
        return url;
    }

    @Override
    public String getMIDletDescription() {
        String description = null;
        if (this.manifestProperties != null) {
            description = this.manifestProperties.getProperty("MIDlet-Description");
        }
        return description;
    }

    @Override
    public String getMIDletIcon() {
        String icon = null;
        if (this.manifestProperties != null) {
            icon = this.manifestProperties.getProperty("MIDlet-Icon");
        }
        return icon;
    }

    @Override
    public String getMIDletInfoURL() {
        String url = null;
        if (this.manifestProperties != null) {
            url = this.manifestProperties.getProperty("MIDlet-Info-URL");
        }
        return url;
    }

    @Override
    public String getMIDletInstallNotify() {
        String url = null;
        if (this.manifestProperties != null) {
            url = this.manifestProperties.getProperty("MIDlet-Install-Notify");
        }
        return url;
    }

    @Override
    public String getMIDletJarSize() {
        String jarsize = null;
        if (this.manifestProperties != null) {
            jarsize = this.manifestProperties.getProperty("MIDlet-Jar-Size");
        }
        return jarsize;
    }

    @Override
    public String getMIDletJarURL() {
        String url = null;
        if (this.manifestProperties != null) {
            url = this.manifestProperties.getProperty("MIDlet-Jar-URL");
        }
        return url;
    }

    @Override
    public String getMIDletName() {
        String name = null;
        if (this.manifestProperties != null) {
            name = this.manifestProperties.getProperty("MIDlet-Name");
        }
        return name;
    }

    @Override
    public String getMIDletPermissions() {
        String permissions = null;
        if (this.manifestProperties != null) {
            permissions = this.manifestProperties.getProperty("MIDlet-Permissions");
        }
        return permissions;
    }

    @Override
    public String getMIDletPermissionsOpt() {
        String permissions = null;
        if (this.manifestProperties != null) {
            permissions = this.manifestProperties.getProperty("MIDlet-Permissions-Opt");
        }
        return permissions;
    }

    @Override
    public String getMIDletVendor() {
        String vendor = null;
        if (this.manifestProperties != null) {
            vendor = this.manifestProperties.getProperty("MIDlet-Vendor");
        }
        return vendor;
    }

    @Override
    public Version getMIDletVersion() {
        String v;
        Version version = Version.emptyVersion;
        if (this.manifestProperties != null && (v = this.manifestProperties.getProperty("MIDlet-Jar-URL")) != null) {
            try {
                version = new Version(v);
            }
            catch (Exception exception) {}
        }
        return version;
    }

    @Override
    public void setMicroEditionConfiguration(String configurations) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MicroEdition-Configuration", configurations);
        }
    }

    @Override
    public void setMicroEditionProfile(String profiles) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MicroEdition-Profile", profiles);
        }
    }

    @Override
    public void setMIDletDataSize(String datasize) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Data-Size", datasize);
        }
    }

    @Override
    public void setMIDletDeleteConfirm(String message) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Delete-Confirm", message);
        }
    }

    @Override
    public void setMIDletDeleteNotify(String url) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Delete-Notify", url);
        }
    }

    @Override
    public void setMIDletDescription(String description) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Description", description);
        }
    }

    @Override
    public void setMIDletIcon(String icon) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Icon", icon);
        }
    }

    @Override
    public void setMIDletInfoURL(String url) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Info-URL", url);
        }
    }

    @Override
    public void setMIDletInstallNotify(String url) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Install-Notify", url);
        }
    }

    @Override
    public void setMIDletJarSize(String jarsize) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Jar-Size", jarsize);
        }
    }

    @Override
    public void setMIDletJarURL(String url) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Jar-URL", url);
        }
    }

    @Override
    public void setMIDletName(String name) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Name", name);
        }
    }

    @Override
    public void setMIDletPermissions(String permissions) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Permissions", permissions);
        }
    }

    @Override
    public void setMIDletPermissionsOpt(String permissions) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Permissions-Opt", permissions);
        }
    }

    @Override
    public void setMIDletVendor(String vendor) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Vendor", vendor);
        }
    }

    @Override
    public void setMIDletVersion(Version version) {
        if (this.manifestProperties != null) {
            this.manifestProperties.setProperty("MIDlet-Version", version.toString());
        }
    }

    @Override
    public void store() throws IOException {
        this.store(this.sourceFile);
    }

    @Override
    public void store(File jadFile) throws IOException {
        ColonDelimitedProperties copy = this.copyProperties();
        for (IMidletDefinition def : this.midletDefinitions) {
            String key = MIDLET_PREFIX + def.getNumber();
            String value = def.toString();
            copy.setProperty(key, value);
        }
        FileOutputStream fos = new FileOutputStream(jadFile);
        try {
            copy.store(fos, "MIDlet Property Definitions");
        }
        catch (Throwable throwable) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fos.close();
        }
        catch (IOException iOException) {}
    }

    private ColonDelimitedProperties copyProperties() {
        ColonDelimitedProperties copy = new ColonDelimitedProperties();
        for (String string : this.manifestProperties.keySet()) {
            String value = this.manifestProperties.getProperty(string);
            copy.setProperty(string, value);
        }
        return copy;
    }

    private void parseDescriptor(File jadFile) throws IOException {
        this.manifestProperties = new ColonDelimitedProperties();
        if (jadFile.exists()) {
            FileInputStream fis = new FileInputStream(jadFile);
            this.manifestProperties.load(fis);
            this.parseMidletDefinitions();
        }
    }

    private void parseMidletDefinitions() {
        ArrayList<String> keysToRemove = new ArrayList<String>(this.manifestProperties.size());
        for (String string : this.manifestProperties.keySet()) {
            if (!string.startsWith(MIDLET_PREFIX)) continue;
            int midletNumber = -1;
            try {
                midletNumber = Integer.parseInt(string.substring(MIDLET_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {}
            if (midletNumber == -1) continue;
            String value = this.manifestProperties.getProperty(string);
            this.midletDefinitions.add(new MidletDefinition(midletNumber, value));
            keysToRemove.add(string);
        }
        for (String key : keysToRemove) {
            this.manifestProperties.remove(key);
        }
    }

    public static class MidletDefinition
    implements IMidletDefinition {
        private String className;
        private String icon;
        private String name;
        private int number;

        public MidletDefinition(int number, String name, String icon, String className) {
            this.number = number;
            this.name = name;
            this.icon = icon;
            this.className = className;
        }

        MidletDefinition(int number, String definitionString) {
            int fieldCount = 0;
            this.number = number;
            this.name = "";
            this.icon = "";
            this.className = "";
            StringTokenizer st = new StringTokenizer(definitionString, ",", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals(",")) {
                    ++fieldCount;
                    continue;
                }
                switch (fieldCount) {
                    case 0: {
                        this.name = token;
                        break;
                    }
                    case 1: {
                        this.icon = token;
                        break;
                    }
                    case 2: {
                        this.className = token;
                    }
                }
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name).append(',');
            sb.append(this.icon).append(',');
            sb.append(this.className);
            return sb.toString();
        }
    }
}

