/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.core.project.midp.IJADDescriptorsProvider;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class JADAttributesRegistry
implements IRegistryChangeListener {
    private static final String JAD_ATTRIBUTE_EXTENSION = "jadattributes";
    private static JADAttributesConfigElement[] allJADAttrElements;
    private static Map<String, JADAttributesConfigElement[]> genericPageJADAttrMap;
    private static IJADDescriptorsProvider[] JADDescriptorproviders;
    private static JADAttributesRegistry registryChangeListener;

    static {
        genericPageJADAttrMap = new HashMap<String, JADAttributesConfigElement[]>();
    }

    public static IJADDescriptorsProvider[] getAllJADDescriptorProviders() {
        JADAttributesConfigElement[] configs = JADAttributesRegistry.getAllJADAttributeElements();
        if (JADDescriptorproviders == null) {
            JADDescriptorproviders = new IJADDescriptorsProvider[configs.length];
            try {
                int i = 0;
                while (i < configs.length) {
                    JADAttributesRegistry.JADDescriptorproviders[i] = configs[i].getJadDescriptorsProvider();
                    ++i;
                }
            }
            catch (CoreException ex) {
                MTJLogger.log(2, "Unable to read the JAD descriptor", ex);
            }
        }
        return JADDescriptorproviders;
    }

    public static DescriptorPropertyDescription[] getJADAttrDescriptorsByPage(String pageID) {
        DescriptorPropertyDescription[] resultAttributes;
        JADAttributesConfigElement[] relatedElements = JADAttributesRegistry.getRelatedAttrElements(pageID);
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = resultAttributes = JADAttributesRegistry.getDescriptorsFromElements(relatedElements);
        int n = resultAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            DescriptorPropertyDescription descriptorPropertyDescription = descriptorPropertyDescriptionArray[n2];
            if (pageID.contains(".")) {
                String[] ids = pageID.split("\\.");
                descriptorPropertyDescription.setPageId(ids[0]);
                descriptorPropertyDescription.setSectionId(ids[1]);
            } else {
                descriptorPropertyDescription.setPageId(pageID);
            }
            ++n2;
        }
        return resultAttributes;
    }

    private static JADAttributesConfigElement[] filterElements(JADAttributesConfigElement[] elements, IMIDPDevice device, String pageID, boolean excludeVendorSpec) {
        ArrayList<JADAttributesConfigElement> resultDescriptorList = new ArrayList<JADAttributesConfigElement>();
        JADAttributesConfigElement[] jADAttributesConfigElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JADAttributesConfigElement element = jADAttributesConfigElementArray[n2];
            boolean satisfied = true;
            if (device != null) {
                satisfied &= element.isVendorSpec() && JADAttributesRegistry.isDeviceMatchVendor(device, element);
            }
            if (pageID != null) {
                satisfied &= element.getAttributesShowPage().equalsIgnoreCase(pageID);
            }
            if (excludeVendorSpec) {
                satisfied &= !element.isVendorSpec();
            }
            if (satisfied) {
                resultDescriptorList.add(element);
            }
            ++n2;
        }
        return resultDescriptorList.toArray(new JADAttributesConfigElement[0]);
    }

    private static JADAttributesConfigElement[] filterElementsByPageAndVendorSpec(JADAttributesConfigElement[] elements, String pageID, boolean excludeVendorSpec) {
        return JADAttributesRegistry.filterElements(elements, null, pageID, excludeVendorSpec);
    }

    private static JADAttributesConfigElement[] getAllJADAttributeElements() {
        if (allJADAttrElements == null) {
            allJADAttrElements = JADAttributesRegistry.readAllJADAttributes();
            registryChangeListener = new JADAttributesRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)registryChangeListener);
        }
        return allJADAttrElements;
    }

    private static DescriptorPropertyDescription[] getDescriptorsFromElements(JADAttributesConfigElement[] elements) {
        ArrayList<DescriptorPropertyDescription> descriptorList = new ArrayList<DescriptorPropertyDescription>();
        JADAttributesConfigElement[] jADAttributesConfigElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JADAttributesConfigElement element = jADAttributesConfigElementArray[n2];
            try {
                IJADDescriptorsProvider provider = element.getJadDescriptorsProvider();
                DescriptorPropertyDescription[] descriptorArray = provider.getDescriptorPropertyDescriptions();
                descriptorList.addAll(Arrays.asList(descriptorArray));
            }
            catch (Exception e) {
                MTJLogger.log(2, "Errors happened while determining device/vendor specifc JAD attributes", e);
            }
            ++n2;
        }
        return descriptorList.toArray(new DescriptorPropertyDescription[descriptorList.size()]);
    }

    private static JADAttributesConfigElement[] getGenericElements(String pageID) {
        JADAttributesConfigElement[] elements = JADAttributesRegistry.getAllJADAttributeElements();
        return JADAttributesRegistry.filterElementsByPageAndVendorSpec(elements, pageID, true);
    }

    private static JADAttributesConfigElement[] getRelatedAttrElements(String pageID) {
        JADAttributesConfigElement[] genericElements = null;
        if (!genericPageJADAttrMap.containsKey(pageID)) {
            genericPageJADAttrMap.put(pageID, JADAttributesRegistry.getGenericElements(pageID));
        }
        genericElements = genericPageJADAttrMap.get(pageID);
        return genericElements;
    }

    private static boolean isDeviceMatchVendor(IMIDPDevice device, JADAttributesConfigElement element) {
        return true;
    }

    private static JADAttributesConfigElement[] readAllJADAttributes() {
        String plugin = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(plugin, JAD_ATTRIBUTE_EXTENSION);
        JADAttributesConfigElement[] elements = new JADAttributesConfigElement[configElements.length];
        int i = 0;
        while (i < configElements.length) {
            elements[i] = new JADAttributesConfigElement(configElements[i]);
            ++i;
        }
        return elements;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String plugin = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IExtensionDelta[] deltas = event.getExtensionDeltas(plugin, JAD_ATTRIBUTE_EXTENSION);
        if (deltas.length > 0) {
            genericPageJADAttrMap.clear();
            JADDescriptorproviders = null;
            allJADAttrElements = JADAttributesRegistry.readAllJADAttributes();
        }
    }

    static class JADAttributesConfigElement {
        private static final String JAD_ATTR_SHOW_PAGE = "pageID";
        private static final String JAD_DESCRIPTOR_PROVIDER_CLASS = "class";
        private static final String JAD_DESCRIPTOR_PROVIDER_ELEMENT = "jadDescriptorsProvider";
        private static final String VENDOR_SPEC_ATTR = "vendorSpec";
        private IConfigurationElement element;
        private IJADDescriptorsProvider jadDescriptorsProvider;

        public JADAttributesConfigElement(IConfigurationElement jadAttrElement) {
            this.element = jadAttrElement;
        }

        public String getAttributesShowPage() {
            return this.element.getAttribute(JAD_ATTR_SHOW_PAGE);
        }

        public IJADDescriptorsProvider getJadDescriptorsProvider() throws CoreException {
            IConfigurationElement[] providers;
            if (this.jadDescriptorsProvider == null && (providers = this.element.getChildren(JAD_DESCRIPTOR_PROVIDER_ELEMENT)) != null && providers.length > 0) {
                this.jadDescriptorsProvider = (IJADDescriptorsProvider)providers[0].createExecutableExtension(JAD_DESCRIPTOR_PROVIDER_CLASS);
            }
            return this.jadDescriptorsProvider;
        }

        public boolean isVendorSpec() {
            String value = this.element.getAttribute(VENDOR_SPEC_ATTR);
            return value == null ? false : "true".equalsIgnoreCase(value);
        }
    }
}

