/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.IMTJProjectListener;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMIDPMetaData;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProjectListener;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.sign.PreferencesSignatureProperties;
import org.eclipse.mtj.internal.core.project.midp.ApplicationDescriptor;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MidletSuiteProject
implements IMidletSuiteProject {
    public static final String CLASSES_DIRECTORY = "classes";
    public static final String LIBS_DIRECTORY = "libs";
    private static final String APP_DESCRIPTOR_FILE_EXT = "jad";
    private static final String DEPLOYED_APP_FILE_EXT = "jar";
    private IJavaProject javaProject;
    private IMIDPMetaData metaData;
    private String tempKeyPassword;
    private String tempKeystorePassword;
    List<IMidletSuiteProjectListener> listenerList = new ArrayList<IMidletSuiteProjectListener>();

    public static String getDefaultJadFileName(IProject project) {
        String projectName = project.getName();
        return NLS.bind((String)"{0}.{1}", (Object[])new String[]{projectName.replace(' ', '_'), APP_DESCRIPTOR_FILE_EXT});
    }

    public MidletSuiteProject(IJavaProject javaProject) throws IllegalArgumentException {
        if (javaProject == null) {
            throw new IllegalArgumentException("A non-null IJavaProject must be passed to constructor.");
        }
        this.javaProject = javaProject;
        this.initializeMetadata();
        MTJRuntime mtjRuntime = this.getRuntimeList().getActiveMTJRuntime();
        if (mtjRuntime != null && mtjRuntime.getDevice() == null) {
            try {
                if (this.getProject().findMarkers("org.eclipse.mtj.core.device.missing", false, 0).length == 0) {
                    IMarker marker = this.getProject().createMarker("org.eclipse.mtj.core.device.missing");
                    marker.setAttribute("message", (Object)Messages.MidletSuiteProject_device_not_available);
                    marker.setAttribute("severity", 2);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addMTJProjectListener(IMTJProjectListener listener) {
        if (!this.listenerList.contains(listener) && listener instanceof IMidletSuiteProjectListener) {
            this.listenerList.add((IMidletSuiteProjectListener)listener);
        }
    }

    @Override
    public void createPackage(boolean obfuscate, boolean packageInactiveConfigs, IProgressMonitor monitor) throws CoreException {
        ArrayList<MTJRuntime> configurationList = new ArrayList<MTJRuntime>();
        MTJRuntimeList rtList = this.getRuntimeList();
        if (packageInactiveConfigs) {
            for (MTJRuntime mtjRuntime : rtList) {
                configurationList.add(mtjRuntime);
            }
        } else {
            configurationList.add(rtList.getActiveMTJRuntime());
        }
        this.createPackage(configurationList, obfuscate, null, monitor);
    }

    public void createPackage(List<MTJRuntime> configurationList, boolean obfuscate, String destination, IProgressMonitor monitor) throws CoreException {
        boolean isAutoBuilding;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("_do_package", Boolean.TRUE.toString());
        args.put("_do_obfuscation", Boolean.valueOf(obfuscate).toString());
        args.put("_update_version", Boolean.TRUE.toString());
        if (destination != null && !destination.isEmpty()) {
            args.put("_destination_dir", destination);
        }
        if (isAutoBuilding = Utils.isAutoBuilding()) {
            Utils.switchAutoBuild(false);
        }
        BuildSpecManipulator manipulator = new BuildSpecManipulator(this.getProject());
        manipulator.setBuilderArguments("org.eclipse.mtj.core.packageBuilder", args);
        manipulator.commitChanges(monitor);
        MTJRuntimeList configurations = this.getRuntimeList();
        MTJRuntime activeConfig = configurations.getActiveMTJRuntime();
        IDevice deviceOfFormerConfig = activeConfig.getDevice();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)configurationList.size());
        for (MTJRuntime config : configurationList) {
            if (config != activeConfig) {
                configurations.switchActiveMTJRuntime(config);
                IDevice device = config.getDevice();
                if (deviceOfFormerConfig != device) {
                    this.changeJavaMEClasspathContainer(device, false, monitor);
                    deviceOfFormerConfig = device;
                }
            }
            this.getProject().build(6, (IProgressMonitor)subMonitor.newChild(1));
        }
        manipulator.setBuilderArguments("org.eclipse.mtj.core.packageBuilder", new HashMap<String, String>());
        manipulator.commitChanges(monitor);
        if (isAutoBuilding) {
            Utils.switchAutoBuild(true);
        }
        this.restoreProjectSettings(configurations, activeConfig, deviceOfFormerConfig, monitor);
        for (IMidletSuiteProjectListener midletSuiteProjectListener : this.listenerList) {
            midletSuiteProjectListener.packageCreated();
        }
    }

    @Override
    public IApplicationDescriptor getApplicationDescriptor() {
        ApplicationDescriptor descriptor = null;
        IFile jadFile = this.getApplicationDescriptorFile();
        jadFile.exists();
        try {
            File jFile = jadFile.getLocation().toFile();
            descriptor = new ApplicationDescriptor(jFile);
        }
        catch (IOException e) {
            MTJLogger.log(4, "getApplicationDescriptor", e);
        }
        return descriptor;
    }

    @Override
    public IFile getApplicationDescriptorFile() {
        IFile jadFile = null;
        IProject project = this.javaProject.getProject();
        jadFile = project.getFile("Application Descriptor");
        return jadFile;
    }

    @Override
    public String getJadFileName() {
        return this.metaData.getJadFileName();
    }

    @Override
    public String getJarFilename() {
        String filename = null;
        String jarUrl = this.getApplicationDescriptor().getMIDletJarURL();
        if (jarUrl != null) {
            int lastSlashIndex = jarUrl.lastIndexOf(47);
            filename = lastSlashIndex != -1 ? jarUrl.substring(lastSlashIndex + 1) : jarUrl;
        }
        if (filename == null) {
            filename = NLS.bind((String)"{0}.{1}", (Object[])new String[]{this.getProjectNameWithoutSpaces(), DEPLOYED_APP_FILE_EXT});
        }
        return filename;
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    public IProject getProject() {
        return this.javaProject.getProject();
    }

    @Override
    public MTJRuntimeList getRuntimeList() {
        return this.metaData.getRuntimeList();
    }

    @Override
    public ISignatureProperties getSignatureProperties() throws CoreException {
        ISignatureProperties result = this.metaData.getSignatureProperties();
        if (result != null && !result.isProjectSpecific()) {
            boolean signingProject = result.isSignProject();
            String projectAlias = result.getKeyAlias();
            result = new PreferencesSignatureProperties();
            result.setSignProject(signingProject);
            if (projectAlias != null && projectAlias.length() > 0) {
                result.setKeyAlias(projectAlias);
            }
        }
        return result;
    }

    @Override
    public String getTempKeyPassword() {
        return this.tempKeyPassword;
    }

    @Override
    public String getTempKeystorePassword() {
        return this.tempKeystorePassword;
    }

    @Override
    public IFolder getVerifiedClassesOutputFolder(IProgressMonitor monitor) {
        return this.getVerifiedOutputFolder(monitor).getFolder(CLASSES_DIRECTORY);
    }

    @Override
    public IFolder getVerifiedLibrariesOutputFolder(IProgressMonitor monitor) {
        return this.getVerifiedOutputFolder(monitor).getFolder(LIBS_DIRECTORY);
    }

    @Override
    public IFolder getVerifiedOutputFolder(IProgressMonitor monitor) {
        IFolder tempFolder = this.getProject().getFolder(".mtj.tmp");
        return tempFolder.getFolder("verified");
    }

    public boolean isPreprocessedProject() {
        IProject project = this.getProject();
        boolean isPreprocessed = false;
        if (project.exists() && project.isOpen()) {
            try {
                isPreprocessed = project.hasNature("org.eclipse.mtj.core.preprocessingNature");
            }
            catch (CoreException coreException) {}
        }
        return isPreprocessed;
    }

    @Override
    public IPreverificationError[] preverify(IResource[] toVerify, IFolder outputFolder, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        return this.getPreverifier().preverify(this, toVerify, outputFolder, monitor);
    }

    @Override
    public IPreverificationError[] preverifyJarFile(File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        return this.getPreverifier().preverifyJarFile(this, jarFile, outputFolder, monitor);
    }

    @Override
    public void refreshClasspath(IProgressMonitor monitor) throws CoreException {
        IDevice device;
        MTJRuntime mtjRuntime = this.getRuntimeList().getActiveMTJRuntime();
        if (mtjRuntime != null && (device = mtjRuntime.getDevice()) != null) {
            this.getProject().deleteMarkers("org.eclipse.mtj.core.device.missing", false, 0);
            this.changeJavaMEClasspathContainer(device, true, monitor);
            for (IMidletSuiteProjectListener midletSuiteProjectListener : this.listenerList) {
                midletSuiteProjectListener.classpathRefreshed();
            }
        }
    }

    @Override
    public void removeMTJProjectListener(IMTJProjectListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void saveMetaData() throws CoreException {
        this.metaData.saveMetaData();
        for (IMTJProjectListener iMTJProjectListener : this.listenerList) {
            iMTJProjectListener.metaDataSaved();
        }
    }

    @Override
    public void setSdkProviderMetaData(String sdkId, Properties sdkMetaData) throws IllegalArgumentException {
        this.metaData.setSDKProviderMetaData(sdkId, sdkMetaData);
    }

    @Override
    public Properties getSdkProviderMetaData(String sdkId) throws IllegalArgumentException {
        return this.metaData.getSDKProviderMetaData(sdkId);
    }

    @Override
    public void setJadFileName(String jadFileName) {
        this.metaData.setJadFileName(jadFileName);
        for (IMTJProjectListener iMTJProjectListener : this.listenerList) {
            ((IMidletSuiteProjectListener)iMTJProjectListener).jadFileNameChanged();
        }
    }

    @Override
    public void setSignatureProperties(ISignatureProperties props) {
        this.metaData.setSignatureProperties(props);
        for (IMTJProjectListener iMTJProjectListener : this.listenerList) {
            iMTJProjectListener.signaturePropertiesChanged();
        }
    }

    @Override
    public void setTempKeyPassword(String pass) {
        this.tempKeyPassword = pass;
        for (IMidletSuiteProjectListener midletSuiteProjectListener : this.listenerList) {
            midletSuiteProjectListener.tempKeyPasswordChanged();
        }
    }

    @Override
    public void setTempKeystorePassword(String pass) {
        this.tempKeystorePassword = pass;
        for (IMidletSuiteProjectListener midletSuiteProjectListener : this.listenerList) {
            midletSuiteProjectListener.tempKeystorePasswordChanged();
        }
    }

    private void addClasspathContainerIfMissing(IProgressMonitor monitor) throws JavaModelException {
        boolean hasClasspathContainer = this.containsJavaMEClasspathContainer(this.getJavaProject());
        boolean hasPreprocessingNature = this.isPreprocessedProject();
        if (!hasClasspathContainer && !hasPreprocessingNature) {
            IClasspathEntry[] platformEntries;
            Path entryPath = new Path("org.elipse.mtj.JavaMEContainer/" + this.getRuntimeList().getActiveMTJRuntime().getDevice());
            IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)entryPath);
            IClasspathEntry[] rawClasspath = this.javaProject.getRawClasspath();
            LinkedHashSet<IClasspathEntry> currentClasspath = new LinkedHashSet<IClasspathEntry>(rawClasspath.length);
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 4) {
                    entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                }
                currentClasspath.add(entry);
                ++n2;
            }
            List<IClasspathEntry> entries = this.getRuntimeList().getActiveMTJRuntime().getDevice().getClasspath().asClasspathEntries();
            IClasspathEntry[] iClasspathEntryArray2 = platformEntries = entries.toArray(new IClasspathEntry[entries.size()]);
            int n3 = platformEntries.length;
            int n4 = 0;
            while (n4 < n3) {
                IClasspathEntry entry = iClasspathEntryArray2[n4];
                if (currentClasspath.contains(entry)) {
                    currentClasspath.remove(entry);
                }
                ++n4;
            }
            currentClasspath.add(newEntry);
            IClasspathEntry[] newClasspath = currentClasspath.toArray(new IClasspathEntry[currentClasspath.size()]);
            this.javaProject.setRawClasspath(newClasspath, monitor);
        }
    }

    private void changeJavaMEClasspathContainer(IDevice device, boolean doBuild, IProgressMonitor monitor) throws CoreException, JavaModelException, OperationCanceledException {
        this.addClasspathContainerIfMissing(monitor);
        IClasspathEntry[] rawClasspath = this.javaProject.getRawClasspath();
        int i = 0;
        while (i < rawClasspath.length) {
            Path entryPath;
            IPath path;
            IClasspathEntry entry = rawClasspath[i];
            if (entry.getEntryKind() == 5 && (path = entry.getPath()).segment(0).equals("org.elipse.mtj.JavaMEContainer") && !entry.equals(entryPath = new Path("org.elipse.mtj.JavaMEContainer/" + device))) {
                rawClasspath[i] = JavaCore.newContainerEntry((IPath)entryPath);
                this.javaProject.setRawClasspath(null, monitor);
                this.javaProject.setRawClasspath(rawClasspath, monitor);
                if (!doBuild) break;
                this.getProject().build(6, monitor);
                break;
            }
            ++i;
        }
    }

    private boolean containsJavaMEClasspathContainer(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] classpath;
        boolean contains = false;
        IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("org.elipse.mtj.JavaMEContainer")) {
                contains = true;
                break;
            }
            ++n2;
        }
        return contains;
    }

    private IPreverifier getPreverifier() throws CoreException, PreverifierNotFoundException {
        IPreverifier preverifier = null;
        IMIDPDevice device = null;
        MTJRuntime active = this.getRuntimeList().getActiveMTJRuntime();
        if (active != null) {
            device = (IMIDPDevice)active.getDevice();
        }
        if (device == null) {
            throw new PreverifierNotFoundException(Messages.MidletSuiteProject_preverifier_missing_device);
        }
        String currentPreverifier = this.getPreverifierType();
        if (currentPreverifier.equals("preverify_proguard")) {
            preverifier = MTJCore.createPreverifier("org.eclipse.mtj.preverifier.proguard", null);
        } else {
            IPreverifier iPreverifier = preverifier = device.getPreverifier() != null ? device.getPreverifier() : MTJCore.getDeviceRegistry().getDefaultPreferifier();
        }
        if (preverifier == null) {
            throw new PreverifierNotFoundException(Messages.MidletSuiteProject_preverifier_missing_default);
        }
        return preverifier;
    }

    private String getPreverifierType() {
        return PreferenceAccessor.instance.getPreverifierType(this.getProject());
    }

    private String getProjectNameWithoutSpaces() {
        String projectName = this.javaProject.getProject().getName();
        return projectName.replace(' ', '_');
    }

    private void initializeMetadata() {
        try {
            if (this.isPreprocessedProject()) {
                IProject targetProject;
                String targetProjectName;
                ICommand[] buildCommands;
                ICommand preverifierCommand = null;
                ICommand[] iCommandArray = buildCommands = this.getProject().getDescription().getBuildSpec();
                int n = buildCommands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    if (command.getBuilderName().equals("org.eclipse.mtj.core.preverifier")) {
                        preverifierCommand = command;
                        break;
                    }
                    ++n2;
                }
                if (preverifierCommand != null && (targetProjectName = (String)preverifierCommand.getArguments().get("preverifyTargetProject")) != null && (targetProject = MTJCore.getWorkspace().getRoot().getProject(targetProjectName)) != null && targetProject.exists()) {
                    this.metaData = new MetaData(targetProject);
                }
            }
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        if (this.metaData == null) {
            this.metaData = new MetaData(this);
        }
    }

    private void restoreProjectSettings(MTJRuntimeList configurations, MTJRuntime activeConfig, IDevice deviceOfFormerConfig, IProgressMonitor monitor) throws CoreException, JavaModelException {
        configurations.switchActiveMTJRuntime(activeConfig);
        if (deviceOfFormerConfig != activeConfig.getDevice()) {
            this.changeJavaMEClasspathContainer(activeConfig.getDevice(), false, monitor);
        }
        this.getProject().build(6, monitor);
    }
}

