/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class BuildPropertiesChange
extends TextFileChange {
    private boolean changed;
    private String oldName;
    private String newName;

    public BuildPropertiesChange(IFile _file, String _oldName, String _newName) {
        super(Messages.BuildPropertiesChange_changeMessage, _file);
        this.oldName = _oldName;
        this.newName = _newName;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            TextEdit[] edits;
            String content = this.getCurrentContent((IProgressMonitor)monitor);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            TextEdit[] textEditArray = edits = this.createTextEdits(content, (IProgressMonitor)monitor);
            int n = edits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit textEdit = textEditArray[n2];
                multiTextEdit.addChild(textEdit);
                ++n2;
            }
            this.changed = edits.length > 0;
            this.setEdit((TextEdit)multiTextEdit);
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
    }

    public boolean hasPropertiesChanges() {
        return this.changed;
    }

    private TextEdit[] createTextEdits(String content, IProgressMonitor monitor) {
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>();
        Pattern pattern = Pattern.compile(this.oldName);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int start = matcher.start();
            int length = matcher.end() - start;
            ReplaceEdit edit = new ReplaceEdit(start, length, this.newName);
            edits.add(edit);
        }
        TextEdit[] array = new TextEdit[edits.size()];
        edits.toArray(array);
        return array;
    }
}

