/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.persistence.PersistableUtilities;
import org.eclipse.mtj.internal.core.sdk.AbstractSDKProvider;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedSDKProvider
extends AbstractSDKProvider {
    private static ImportedSDKProvider instance = null;

    public static synchronized ImportedSDKProvider getInstance() {
        if (instance == null) {
            instance = new ImportedSDKProvider();
        }
        return instance;
    }

    private ImportedSDKProvider() {
        this.name = Messages.SdkProvider_ImportedSdkProviderName;
    }

    @Override
    public String getIdentifier() {
        return "MtjImportedSdkProviderId";
    }

    @Override
    public int getSDKCount() {
        return this.getSDKs().size();
    }

    @Override
    public List<ISDK> getSDKs() {
        List<IDevice> allDevices;
        ArrayList<ISDK> importedSdks = new ArrayList<ISDK>();
        try {
            allDevices = DeviceRegistry.getInstance().getAllDevices();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return importedSdks;
        }
        for (IDevice device : allDevices) {
            ISDK sdk;
            if (device instanceof IManagedDevice || (sdk = device.getSDK()) == null || importedSdks.contains(sdk)) continue;
            importedSdks.add(sdk);
        }
        return importedSdks;
    }

    public boolean removeDevice(IDevice device) {
        try {
            MTJCore.getDeviceRegistry().removeDevice(device);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public IDevice duplicateDevice(IDevice device, String newName) {
        IDevice clonedDevice = null;
        try {
            clonedDevice = (IDevice)PersistableUtilities.clonePersistable(device);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return null;
        }
        clonedDevice.setName(newName);
        MTJCore.getDeviceRegistry().enableDeviceAddedEvent(true);
        try {
            MTJCore.getDeviceRegistry().addDevice(clonedDevice);
            return clonedDevice;
        }
        catch (IllegalArgumentException e) {
            MTJCore.getDeviceRegistry().enableDeviceAddedEvent(false);
            e.printStackTrace();
        }
        catch (PersistenceException e) {
            MTJCore.getDeviceRegistry().enableDeviceAddedEvent(false);
            e.printStackTrace();
        }
        return null;
    }
}

