/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IBundleReferencePersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilder;
import org.eclipse.mtj.internal.core.launching.midp.LaunchingUtils;
import org.eclipse.mtj.internal.core.launching.midp.ota.OTAServer;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMIDPDevice
implements IMIDPDevice,
IBundleReferencePersistable {
    protected String bundle;
    protected boolean debugServer;
    protected String description;
    protected IDeviceClasspath deviceClasspath;
    protected Properties deviceProperties;
    protected ISymbolSet deviceSymbolSet;
    protected File executable;
    protected String groupName;
    protected String launchCommandTemplate;
    protected String name;
    protected IPreverifier preverifier;
    protected String[] protectionDomains;
    protected ISDK sdk;

    public boolean equals(AbstractMIDPDevice device) {
        return (this.deviceClasspath == null ? device.deviceClasspath == null : this.deviceClasspath.equals(device.deviceClasspath)) && (this.executable == null ? device.executable == null : this.executable.equals(device.executable)) && (this.name == null ? device.name == null : this.name.equals(device.name)) && (this.groupName == null ? device.groupName == null : this.groupName.equals(device.groupName));
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public IDeviceClasspath getClasspath() {
        return this.deviceClasspath;
    }

    @Override
    public IMIDPAPI getCLDCAPI() {
        List<IMIDPAPI> cldcLibs = this.getLibrariesWithType(MIDPAPIType.CONFIGURATION);
        IMIDPAPI cldcApi = null;
        if (!cldcLibs.isEmpty()) {
            cldcApi = cldcLibs.get(0);
            for (IMIDPAPI api : cldcLibs) {
                if (api.getVersion().compareTo(cldcApi.getVersion()) <= 0) continue;
                cldcApi = api;
            }
        }
        return cldcApi;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public File getExecutable() {
        return this.executable;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public String getLaunchCommandTemplate() {
        return this.launchCommandTemplate;
    }

    @Override
    public IMIDPAPI getMIDPAPI() {
        List<IMIDPAPI> midpLibs = this.getLibrariesWithType(MIDPAPIType.PROFILE);
        IMIDPAPI midpApi = null;
        if (!midpLibs.isEmpty()) {
            midpApi = midpLibs.get(0);
            for (IMIDPAPI api : midpLibs) {
                if (api.getVersion().compareTo(midpApi.getVersion()) <= 0) continue;
                midpApi = api;
            }
        }
        return midpApi;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPreverifier getPreverifier() {
        return this.preverifier;
    }

    @Override
    public String[] getProtectionDomains() {
        return this.protectionDomains;
    }

    @Override
    public ISDK getSDK() {
        return this.sdk;
    }

    @Override
    public String getSDKName() {
        return this.sdk.getName();
    }

    @Override
    public ISymbolSet getSymbolSet() {
        return this.deviceSymbolSet;
    }

    @Override
    public boolean isDebugServer() {
        return this.debugServer;
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        this.deviceClasspath = (DeviceClasspath)persistenceProvider.loadPersistable("classpath");
        this.debugServer = persistenceProvider.loadBoolean("debugServer");
        this.description = persistenceProvider.loadString("description");
        this.deviceProperties = persistenceProvider.loadProperties("deviceProperties");
        this.name = persistenceProvider.loadString("name");
        this.protectionDomains = new String[persistenceProvider.loadInteger("protectionDomainsCount")];
        int i = 0;
        while (i < this.protectionDomains.length) {
            this.protectionDomains[i] = persistenceProvider.loadString("protectionDomain" + i).trim();
            ++i;
        }
        this.groupName = persistenceProvider.loadString("groupName");
        this.preverifier = (IPreverifier)persistenceProvider.loadPersistable("preverifier");
        this.launchCommandTemplate = persistenceProvider.loadString("rawLaunchCommand");
        String executableString = persistenceProvider.loadString("executable");
        if (executableString != null && executableString.trim().length() > 0) {
            this.executable = new File(executableString);
        }
        this.deviceSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice(this);
        ISymbolSet pss = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(this.deviceProperties);
        this.deviceSymbolSet.add(pss.getSymbols());
        this.deviceSymbolSet.setName(this.name);
        Version v = new Version(1, 0, 0);
        this.sdk = BasicSDK.getSDK(this.groupName, v);
        ((BasicSDK)this.sdk).addDevice(this);
    }

    @Override
    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setClasspath(IDeviceClasspath deviceClasspath) {
        this.deviceClasspath = deviceClasspath;
    }

    public void setDebugServer(boolean debugServer) {
        this.debugServer = debugServer;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDeviceProperties(Properties deviceProperties) {
        this.deviceProperties = deviceProperties;
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setLaunchCommandTemplate(String launchCommandTemplate) {
        this.launchCommandTemplate = launchCommandTemplate;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setPreverifier(IPreverifier preverifier) {
        this.preverifier = preverifier;
    }

    public void setProtectionDomains(String[] protectionDomains) {
        this.protectionDomains = protectionDomains;
        int i = 0;
        while (i < protectionDomains.length) {
            protectionDomains[i] = protectionDomains[i].trim();
            ++i;
        }
    }

    public void setSDK(ISDK sdk) {
        this.sdk = sdk;
    }

    public synchronized void setSymbolSet(ISymbolSet symbolSet) {
        this.deviceSymbolSet = symbolSet;
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storePersistable("classpath", this.deviceClasspath);
        persistenceProvider.storeBoolean("debugServer", this.debugServer);
        persistenceProvider.storeString("description", this.description);
        persistenceProvider.storeProperties("deviceProperties", this.deviceProperties);
        persistenceProvider.storeString("name", this.name);
        persistenceProvider.storeInteger("protectionDomainsCount", this.protectionDomains.length);
        int i = 0;
        while (i < this.protectionDomains.length) {
            persistenceProvider.storeString("protectionDomain" + i, this.protectionDomains[i]);
            ++i;
        }
        persistenceProvider.storeString("groupName", this.groupName);
        persistenceProvider.storePersistable("preverifier", this.preverifier);
        persistenceProvider.storeString("rawLaunchCommand", this.launchCommandTemplate);
        if (this.executable != null) {
            persistenceProvider.storeString("executable", this.executable.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getSDKName());
        sb.append("/").append(this.getName());
        return sb.toString();
    }

    private List<IMIDPAPI> getLibrariesWithType(MIDPAPIType type) {
        ArrayList<IMIDPAPI> result = new ArrayList<IMIDPAPI>();
        IDeviceClasspath deviceClasspath = this.getClasspath();
        List<ILibrary> libraries = deviceClasspath.getEntries();
        for (ILibrary library : libraries) {
            if (!(library instanceof IMIDPLibrary) || ((IMIDPLibrary)library).getAPI(type) == null) continue;
            result.add(((IMIDPLibrary)library).getAPI(type));
        }
        return result;
    }

    protected void addLaunchConfigurationValue(Map<String, String> executionProperties, String propertyName, ILaunchConfiguration launchConfiguration, String launchConstant) throws CoreException {
        String configValue = launchConfiguration.getAttribute(launchConstant, null);
        if (configValue != null) {
            executionProperties.put(propertyName, configValue);
        }
    }

    protected File copyForLaunch(IMidletSuiteProject suite, IProgressMonitor monitor, boolean launchFromJad) throws CoreException {
        try {
            if (launchFromJad) {
                IFolder emulationFolder = LaunchingUtils.getEmulationFolder(suite);
                File jadLaunchDir = LaunchingUtils.makeJadLaunchBaseDir(suite);
                File runtimeJad = emulationFolder.getFile(suite.getJadFileName()).getLocation().toFile();
                File runtimeJar = emulationFolder.getFile(suite.getJarFilename()).getLocation().toFile();
                File emulateJad = new File(jadLaunchDir, suite.getJadFileName());
                File emulateJar = new File(jadLaunchDir, suite.getJarFilename());
                Utils.copyFile(runtimeJad, emulateJad, null);
                Utils.copyFile(runtimeJar, emulateJar, null);
                LaunchingUtils.getProjectTempFolder(suite).refreshLocal(2, monitor);
                return jadLaunchDir;
            }
            File tempFolder = null;
            IFolder emulationFolder = LaunchingUtils.getEmulationFolder(suite);
            File emulationDirectory = emulationFolder.getLocation().toFile();
            String folderName = suite.getProject().getName().replace(' ', '_');
            tempFolder = TemporaryFileManager.instance.createTempDirectory(folderName, ".launch");
            Utils.copyDirectory(emulationDirectory, tempFolder, null);
            return tempFolder;
        }
        catch (IOException e) {
            MTJStatusHandler.throwCoreException(4, -999, e);
            return null;
        }
    }

    protected File getJadForLaunch(IMidletSuiteProject midletSuite, File temporaryDirectory, IProgressMonitor monitor) {
        return new File(temporaryDirectory, midletSuite.getJadFileName());
    }

    protected String getOTAURL(ILaunchConfiguration launchConfig, IMidletSuiteProject midletSuite) throws CoreException {
        try {
            OTAServer.getInstance().start();
        }
        catch (Exception e) {
            MTJLogger.log(2, "Failed to launch OTA Server", e);
        }
        String projectName = midletSuite.getProject().getName();
        String jadName = midletSuite.getJadFileName();
        StringBuffer sb = new StringBuffer();
        sb.append("http://localhost:").append(OTAServer.getPort()).append("/ota/").append(this.urlEncoded(projectName)).append('/').append(this.urlEncoded(jadName));
        return sb.toString();
    }

    protected String getProjectClasspathString(IMTJProject midletSuite, File temporaryDirectory, IProgressMonitor monitor) throws CoreException {
        de.schlichtherle.io.File deployedJar = PackageBuilder.getRuntimeJar(midletSuite.getProject(), monitor);
        return new File(temporaryDirectory, deployedJar.getName()).getAbsolutePath();
    }

    protected String getSpecifiedJadURL(ILaunchConfiguration launchConfiguration) throws CoreException {
        return launchConfiguration.getAttribute("mtj.specified_jad_url", null);
    }

    protected boolean shouldDirectLaunchJAD(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("mtj.do_jad_launch", false);
    }

    protected boolean shouldDoOTA(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("mtj.do_ota", true);
    }

    protected String urlEncoded(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return encoded;
    }
}

