/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.sdk.SDKProviderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedDeviceRegistry {
    ManagedDeviceRegistry() {
    }

    List<IDevice> getAllDevices() throws PersistenceException {
        return this.getAllDevicesInternal(false, null);
    }

    IDevice getDevice(String groupName, String deviceName) throws PersistenceException {
        IDevice device = null;
        List<ISDKProvider> providers = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider provider : providers) {
            List<ISDK> sdks = provider.getSDKs();
            for (ISDK sdk : sdks) {
                List<IDevice> devices;
                if (sdk == null || !sdk.getName().equals(groupName)) continue;
                try {
                    devices = sdk.getDeviceList();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    continue;
                }
                for (IDevice managedDevice : devices) {
                    String autoDeviceName;
                    if (managedDevice == null || !(autoDeviceName = managedDevice.getName()).equals(deviceName)) continue;
                    return managedDevice;
                }
            }
        }
        return device;
    }

    int getDeviceCount() throws PersistenceException {
        int deviceCount = 0;
        List<ISDKProvider> providers = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider provider : providers) {
            List<ISDK> sdks = provider.getSDKs();
            for (ISDK sdk : sdks) {
                List<IDevice> devices;
                if (sdk == null) continue;
                try {
                    devices = sdk.getDeviceList();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    continue;
                }
                for (IDevice managedDevice : devices) {
                    if (managedDevice == null) continue;
                    ++deviceCount;
                }
            }
        }
        return deviceCount;
    }

    List<IDevice> getDevices(String groupName) throws PersistenceException {
        List<IDevice> devices = this.getAllDevicesInternal(true, groupName);
        return devices.isEmpty() ? null : devices;
    }

    List<String> getSDKNames() throws PersistenceException {
        ArrayList<String> sdksNames = new ArrayList<String>();
        List<ISDKProvider> providers = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider provider : providers) {
            List<ISDK> sdks = provider.getSDKs();
            for (ISDK sdk : sdks) {
                if (sdk == null) continue;
                sdksNames.add(sdk.getName());
            }
        }
        return sdksNames;
    }

    private List<IDevice> getAllDevicesInternal(boolean filterByGroupName, String groupName) throws PersistenceException {
        if (!filterByGroupName && groupName != null) {
            throw new IllegalArgumentException("If filterByGroupName is false, groupName should be null");
        }
        if (filterByGroupName && groupName == null) {
            throw new IllegalArgumentException("If filterByGroupName is true, groupName cannot be null");
        }
        ArrayList<IDevice> allDevices = new ArrayList<IDevice>();
        List<ISDKProvider> providers = SDKProviderRegistry.getInstance().getSDKProviders();
        for (ISDKProvider provider : providers) {
            List<ISDK> sdks = provider.getSDKs();
            for (ISDK sdk : sdks) {
                List<IDevice> devices;
                if (sdk == null || filterByGroupName && !sdk.getName().equals(groupName)) continue;
                try {
                    devices = sdk.getDeviceList();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    continue;
                }
                for (IDevice device : devices) {
                    if (device == null) continue;
                    allDevices.add(device);
                }
            }
        }
        return allDevices;
    }
}

