/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDPLibrary
implements IMIDPLibrary {
    private static List<IAccessRule> NO_ACCESS_RULES = new ArrayList<IAccessRule>(0);
    private List<IMIDPAPI> apis;
    private URL javadocURL;
    private File libraryFile;
    private IPath sourceAttachmentPath;
    private IPath sourceAttachmentRootPath;
    private List<IAccessRule> accessRules;

    public MIDPLibrary() {
        this.accessRules = NO_ACCESS_RULES;
    }

    public MIDPLibrary(List<IMIDPAPI> apis, URL javadocURL, File libraryFile, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, List<IAccessRule> accessRules) {
        this.apis = apis;
        this.javadocURL = javadocURL;
        this.libraryFile = libraryFile;
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.accessRules = accessRules;
    }

    public boolean equals(MIDPLibrary library) {
        return this.libraryFile.equals(library.libraryFile);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof MIDPLibrary) {
            equals = this.equals((MIDPLibrary)obj);
        }
        return equals;
    }

    @Override
    public IMIDPAPI getAPI(MIDPAPIType apiType) {
        IMIDPAPI result = null;
        for (IAPI iAPI : this.apis) {
            IMIDPAPI temp = (IMIDPAPI)iAPI;
            if (temp.getType() != apiType) continue;
            result = temp;
            break;
        }
        return result;
    }

    @Override
    public List<? extends IAPI> getAPIs() {
        return this.apis;
    }

    @Override
    public IMIDPAPI getConfiguration() {
        return this.getAPI(MIDPAPIType.CONFIGURATION);
    }

    public URL getJavadocURL() {
        return this.javadocURL;
    }

    public File getLibraryFile() {
        return this.libraryFile;
    }

    @Override
    public IMIDPAPI getProfile() {
        return this.getAPI(MIDPAPIType.PROFILE);
    }

    @Override
    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    @Override
    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    @Override
    public boolean hasConfiguration() {
        return this.getConfiguration() != null;
    }

    public int hashCode() {
        return this.libraryFile.hashCode();
    }

    @Override
    public boolean hasProfile() {
        return this.getProfile() != null;
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        String rootPathString;
        String sourceAttachString;
        this.libraryFile = new File(persistenceProvider.loadString("file"));
        int apiLength = persistenceProvider.loadInteger("apiCount");
        this.apis = new ArrayList<IMIDPAPI>();
        int j = 0;
        while (j < apiLength) {
            IMIDPAPI midpapi = (IMIDPAPI)persistenceProvider.loadPersistable("entry" + j);
            this.apis.add(midpapi);
            ++j;
        }
        String javadocURLString = persistenceProvider.loadString("javadocURL");
        if (javadocURLString != null) {
            try {
                this.javadocURL = new URL(javadocURLString);
            }
            catch (MalformedURLException e) {
                MTJLogger.log(2, "Error loading javadoc url " + javadocURLString, e);
            }
        }
        if ((sourceAttachString = persistenceProvider.loadString("sourceAttachmentPath")) != null) {
            this.sourceAttachmentPath = new Path(sourceAttachString);
        }
        if ((rootPathString = persistenceProvider.loadString("sourceAttachmentRootPath")) != null) {
            this.sourceAttachmentRootPath = new Path(rootPathString);
        }
    }

    @Override
    public void setAccessRules(List<IAccessRule> accessRules) {
        this.accessRules = accessRules;
    }

    @Override
    public void setApis(List<? extends IAPI> apis) {
        this.apis = apis;
    }

    @Override
    public void setJavadocURL(URL javadocURL) {
        this.javadocURL = javadocURL;
    }

    @Override
    public void setLibraryFile(File libraryFile) {
        this.libraryFile = libraryFile;
    }

    @Override
    public void setSourceAttachmentPath(IPath sourceAttachmentPath) {
        this.sourceAttachmentPath = sourceAttachmentPath;
    }

    @Override
    public void setSourceAttachmentRootPath(IPath sourceAttachmentRootPath) {
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storeString("file", this.libraryFile.toString());
        persistenceProvider.storeInteger("apiCount", this.apis.size());
        int i = 0;
        for (IAPI iAPI : this.apis) {
            persistenceProvider.storePersistable("entry" + i++, iAPI);
        }
        if (this.javadocURL != null) {
            persistenceProvider.storeString("javadocURL", this.javadocURL.toString());
        }
        if (this.sourceAttachmentPath != null) {
            persistenceProvider.storeString("sourceAttachmentPath", this.sourceAttachmentPath.toString());
        }
        if (this.sourceAttachmentRootPath != null) {
            persistenceProvider.storeString("sourceAttachmentRootPath", this.sourceAttachmentRootPath.toString());
        }
    }

    @Override
    public IClasspathEntry toClasspathEntry() {
        Path entryPath = new Path(this.libraryFile.toString());
        IClasspathAttribute[] attributes = this.getClasspathAttributes();
        return JavaCore.newLibraryEntry((IPath)entryPath, (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (IAccessRule[])(this.accessRules == null ? NO_ACCESS_RULES.toArray(new IAccessRule[0]) : this.accessRules.toArray(new IAccessRule[this.accessRules.size()])), (IClasspathAttribute[])attributes, (boolean)false);
    }

    @Override
    public File toFile() {
        return this.libraryFile;
    }

    public String toString() {
        return this.libraryFile.toString();
    }

    @Override
    public URL toURL() {
        URL url = null;
        try {
            url = this.libraryFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            MTJLogger.log(4, e);
        }
        return url;
    }

    private IClasspathAttribute[] getClasspathAttributes() {
        ArrayList<IClasspathAttribute> attributes = new ArrayList<IClasspathAttribute>();
        IClasspathAttribute javadocAttribute = this.getJavadocAttribute();
        if (javadocAttribute != null) {
            attributes.add(javadocAttribute);
        }
        return attributes.toArray(new IClasspathAttribute[attributes.size()]);
    }

    private IClasspathAttribute getJavadocAttribute() {
        IClasspathAttribute attribute = null;
        if (this.javadocURL != null) {
            attribute = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)this.javadocURL.toString());
        }
        return attribute;
    }

    @Override
    public List<IAccessRule> getAccessRules() {
        return this.accessRules;
    }
}

