/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;
import org.eclipse.mtj.internal.core.sign.PermissionsGroupsRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPermissionsScanner
extends SearchRequestor {
    private List<PermissionsGroup> permissions = new ArrayList<PermissionsGroup>();
    private IMidletSuiteProject midletSuiteProject;
    private PermissionsGroup currentPermission;

    public SecurityPermissionsScanner(IMidletSuiteProject midletSuiteProject) {
        this.midletSuiteProject = midletSuiteProject;
    }

    public List<PermissionsGroup> getRequiredPermissions() {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.midletSuiteProject.getJavaProject()}, (int)9);
        int matchRule = 8;
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        List<PermissionsGroup> allPermissions = PermissionsGroupsRegistry.getInstance().getPermissions();
        SearchEngine searchEngine = new SearchEngine();
        Iterator<PermissionsGroup> iterator = allPermissions.iterator();
        while (iterator.hasNext()) {
            PermissionsGroup permission;
            this.currentPermission = permission = iterator.next();
            SearchPattern suitePattern = SearchPattern.createPattern((String)permission.getClassName(), (int)0, (int)2, (int)matchRule);
            try {
                searchEngine.search(suitePattern, participants, scope, (SearchRequestor)this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MTJLogger.log(2, "Error while scanning for permissions", e);
            }
        }
        return this.permissions;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (!this.permissions.contains(this.currentPermission)) {
            this.permissions.add(this.currentPermission);
        }
    }
}

