/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.statemachine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.statemachine.AbstractFinalState;
import org.eclipse.mtj.internal.core.statemachine.AbstractState;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateMachineEvent;
import org.eclipse.mtj.internal.core.statemachine.StateMachineListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class StateMachine {
    private List<StateMachineListener> listeners = new ArrayList<StateMachineListener>();
    private List<AbstractState> states = new ArrayList<AbstractState>();
    private AbstractState current;
    private boolean started;

    public synchronized void setInitialState(AbstractState _state) {
        if (_state == null) {
            throw new IllegalArgumentException(Messages.StateMachine_nullInitialState);
        }
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        if (!this.states.contains(_state)) {
            throw new IllegalStateException(Messages.StateMachine_invalidInitialState);
        }
        this.current = _state;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        if (this.current == null) {
            throw new IllegalStateException(Messages.StateMachine_noInitialState);
        }
        this.started = true;
        for (StateMachineListener listener : this.listeners) {
            try {
                listener.started();
            }
            catch (Throwable t) {
                MTJLogger.log(2, t);
            }
        }
        this.current.onEnterState();
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineNotYetStarted);
        }
        this.started = false;
        this.current.onExitState();
        for (StateMachineListener listener : this.listeners) {
            try {
                listener.stopped();
            }
            catch (Throwable t) {
                MTJLogger.log(2, t);
            }
        }
    }

    public synchronized void postEvent(AbstractStateMachineEvent _event) {
        if (!this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineNotYetStarted);
        }
        AbstractState nextState = this.current.postEvent(_event);
        if (nextState != null) {
            this.current.onExitState();
            this.current = nextState;
            this.current.onEnterState();
            if (this.current instanceof AbstractFinalState) {
                for (StateMachineListener listener : this.listeners) {
                    try {
                        listener.finished();
                    }
                    catch (Throwable t) {
                        MTJLogger.log(2, t);
                    }
                }
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addState(AbstractState _state) {
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        List<AbstractState> list = this.states;
        synchronized (list) {
            if (!this.states.contains(_state)) {
                this.states.add(_state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeState(AbstractState _state) {
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        List<AbstractState> list = this.states;
        synchronized (list) {
            this.states.remove(_state);
        }
    }

    public AbstractState[] getStates() {
        return this.states.toArray(new AbstractState[this.states.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateMachineListener(StateMachineListener _listener) {
        List<StateMachineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(_listener)) {
                this.listeners.add(_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateMachineListener(StateMachineListener _listener) {
        List<StateMachineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(_listener);
        }
    }
}

