/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.symbol.ISymbolSetConstants;
import org.eclipse.mtj.internal.core.symbol.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSet
implements ISymbolSet,
ISymbolSetConstants,
Cloneable {
    private String name = "";
    private HashMap<String, ISymbol> symbols = new HashMap();

    @Override
    public ISymbol add(String identifier) {
        Symbol s = new Symbol(identifier, "true");
        this.symbols.put(identifier, s);
        return s;
    }

    @Override
    public ISymbol add(String identifier, String value) {
        Symbol s = new Symbol(identifier, value);
        this.symbols.put(identifier, s);
        return s;
    }

    @Override
    public ISymbol add(String identifier, String value, int type) {
        Symbol s = new Symbol(identifier, value, type);
        this.symbols.put(identifier, s);
        return s;
    }

    @Override
    public boolean contains(String identifier) {
        return this.symbols.containsKey(identifier);
    }

    public boolean equals(Object obj) {
        return obj instanceof SymbolSet && this.equals((SymbolSet)obj);
    }

    @Override
    public boolean equals(ISymbolSet definitions) {
        SymbolSet ss = (SymbolSet)definitions;
        if (!this.name.equals(ss.getName())) {
            return false;
        }
        if (this.getSymbols().size() != definitions.getSymbols().size()) {
            return false;
        }
        for (String type : this.symbols.keySet()) {
            if (!ss.symbols.containsKey(type)) {
                return false;
            }
            if (ss.getSymbolValue(type).equals(this.getSymbolValue(type))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getSymbolSetString();
    }

    public int hashCode() {
        return this.safeHash(this.name) ^ this.safeHash(this.symbols);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSymbolSetString() {
        Collection<ISymbol> c = this.symbols.values();
        StringBuffer sb = new StringBuffer();
        for (ISymbol s : c) {
            sb.append(s.getName()).append("=").append(s.getSafeValue()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String getSymbolValue(String identifier) {
        return this.symbols.get(identifier).getValue();
    }

    @Override
    public Collection<ISymbol> getSymbols() {
        return this.symbols.values();
    }

    @Override
    public void remove(String identifier) {
        this.symbols.remove(identifier);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setSymbols(Map<String, String> definitions) {
        this.symbols.clear();
        for (String identifier : definitions.keySet()) {
            this.add(identifier, definitions.get(identifier));
        }
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Collection<ISymbol> c = this.symbols.values();
        return c.toArray(a);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        Properties properties;
        this.name = persistenceProvider.loadString("mtjName");
        this.symbols.clear();
        String keyString = persistenceProvider.loadString("mtjKeys" + this.getStorableName());
        if (keyString != null && keyString.length() > 0) {
            void var5_8;
            String[] keys;
            String[] stringArray = keys = keyString.split(",");
            int n = keys.length;
            boolean n2 = false;
            while (var5_8 < n) {
                String key = stringArray[var5_8];
                String value = persistenceProvider.loadString(key);
                this.add(key, value);
                ++var5_8;
            }
        }
        if ((properties = persistenceProvider.loadProperties("mtjKeys")) != null) {
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                this.add(string, value);
            }
        }
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storeString("mtjName", this.name);
        Iterator<Map.Entry<String, ISymbol>> entries = this.symbols.entrySet().iterator();
        Properties properties = new Properties();
        while (entries.hasNext()) {
            Map.Entry<String, ISymbol> entry = entries.next();
            properties.put(entry.getKey(), entry.getValue().getValue());
        }
        persistenceProvider.storeProperties("mtjKeys", properties);
    }

    String getStorableName() {
        return this.name.replaceAll("\\ ", "_");
    }

    private int safeHash(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    @Override
    public void add(Collection<ISymbol> c) {
        for (ISymbol s : c) {
            this.symbols.put(s.getName(), s);
        }
    }

    @Override
    public void add(ISymbol s) {
        this.symbols.put(s.getName(), s);
    }

    @Override
    public void remove(Collection<ISymbol> c) {
        for (ISymbol s : c) {
            this.symbols.remove(s.getName());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SymbolSet clone = new SymbolSet();
        clone.setName(this.getName());
        for (ISymbol symbol : this.getSymbols()) {
            clone.add((ISymbol)((Symbol)symbol).clone());
        }
        return clone;
    }
}

