/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolSetFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolUtils {
    public static final String PROP_UEI_VERSION = "uei.version";
    public static final String PROP_UEI_ARGUMENTS = "uei.arguments";
    public static final String PROP_DEVICE_LIST = "device.list";
    public static final String PROP_SECURITY_DOMAINS = "security.domains";
    public static final String PROP_BOOTCLASSPATH = "bootclasspath";
    public static final String PROP_APIS = "apis";
    public static final String PROP_DESCRIPTION = "description";
    private static List<String> excludedProperties = new ArrayList<String>();
    private static final String J2MEPOLISH_CAPABILITY_SEPARATOR = ",";

    static {
        excludedProperties.add(PROP_UEI_VERSION);
        excludedProperties.add(PROP_UEI_ARGUMENTS);
        excludedProperties.add(PROP_DEVICE_LIST);
        excludedProperties.add(PROP_SECURITY_DOMAINS);
        excludedProperties.add(PROP_BOOTCLASSPATH);
        excludedProperties.add(PROP_APIS);
        excludedProperties.add(PROP_DESCRIPTION);
    }

    public static String getSafeSymbolValue(String value) {
        if (value == null || value.trim().length() == 0) {
            value = Boolean.TRUE.toString();
        }
        if (!value.startsWith("\"") && !value.startsWith("'")) {
            value = "'" + value + "'";
        }
        return value;
    }

    public static ISymbolSet createSymbolSet(IDevice device) {
        ISymbolSet symbolSet = SymbolSetFactory.getInstance().createSymbolSet("Default");
        SymbolUtils.addLibrarySymbols(symbolSet, device);
        return symbolSet;
    }

    public static ISymbolSet createSymbolSet(Properties properties) {
        ISymbolSet symbolSet = SymbolSetFactory.getInstance().createSymbolSet("Properties");
        SymbolUtils.populateSymbolSetFromProperties(symbolSet, properties);
        return symbolSet;
    }

    public static String replaceFirstNonLetterChar(String lib) {
        lib = lib.replaceFirst("^[^a-zA-Z].+", "a_" + lib);
        return lib;
    }

    public static List<ISymbolSet> importFromJ2MEPolishFormat(IProgressMonitor monitor, InputStream devicesInputStream, InputStream groupsInputStream) throws PersistenceException, ParserConfigurationException, SAXException, IOException {
        Vector<ISymbolSet> result = new Vector<ISymbolSet>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document devicesDOM = db.parse(devicesInputStream);
        Document groupsDOM = db.parse(groupsInputStream);
        HashMap<String, Element> groups = SymbolUtils.prepareGroups(groupsDOM);
        NodeList nl = devicesDOM.getElementsByTagName("device");
        if (monitor != null) {
            monitor.beginTask("Importing...", nl.getLength());
        }
        int i = 0;
        while (i < nl.getLength()) {
            Element groupElement;
            HashMap<String, String> capabilities = new HashMap<String, String>();
            Element deviceElement = (Element)nl.item(i);
            String name = ((Element)deviceElement.getElementsByTagName("identifier").item(0)).getTextContent();
            Element featuresElement = (Element)deviceElement.getElementsByTagName("features").item(0);
            if (featuresElement != null) {
                String features = featuresElement.getTextContent();
                capabilities.put("features", features);
            }
            if ((groupElement = (Element)deviceElement.getElementsByTagName("groups").item(0)) != null) {
                StringTokenizer st = new StringTokenizer(groupElement.getTextContent(), J2MEPOLISH_CAPABILITY_SEPARATOR);
                while (st.hasMoreTokens()) {
                    String group = st.nextToken().trim();
                    HashMap<String, String> groupCapabilities = SymbolUtils.getGroupCapabilities(groups, group);
                    SymbolUtils.copyCapabilities(capabilities, groupCapabilities);
                }
                capabilities.put("groups", groupElement.getTextContent().toLowerCase());
            }
            NodeList capabilitiesNL = deviceElement.getElementsByTagName("capability");
            int j = 0;
            while (j < capabilitiesNL.getLength()) {
                Element capabilityElement = (Element)capabilitiesNL.item(j);
                SymbolUtils.copyCapability(capabilities, capabilityElement.getAttribute("name"), capabilityElement.getAttribute("value"));
                ++j;
            }
            capabilities.put(name, "true");
            StringTokenizer st = new StringTokenizer(name, J2MEPOLISH_CAPABILITY_SEPARATOR);
            while (st.hasMoreTokens()) {
                String device = st.nextToken().trim();
                device = device.replace('/', '_');
                device = device.replace('(', '_');
                device = device.replace(')', '_');
                ISymbolSet definitionSet = SymbolUtils.createSymbolDefinitionSet(device, capabilities);
                result.add(definitionSet);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ++i;
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    private static void addLibrarySymbols(ISymbolSet symbolSet, IDevice device) {
        if (device == null) {
            return;
        }
        List<ILibrary> libraries = device.getClasspath().getEntries();
        if (libraries != null) {
            for (ILibrary librarie : libraries) {
                for (IAPI iAPI : librarie.getAPIs()) {
                    String key = iAPI.getIdentifier().replace(' ', '_');
                    key = SymbolUtils.replaceFirstNonLetterChar(key);
                    String value = NLS.bind((String)"{0}.{1}", (Object[])new Object[]{iAPI.getVersion().getMajor(), iAPI.getVersion().getMinor()});
                    symbolSet.add(key, value);
                }
            }
        }
    }

    private static void populateSymbolSetFromProperties(ISymbolSet symbolSet, Properties prop) {
        Properties properties = prop;
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = String.valueOf(entry.getKey());
            if (excludedProperties.contains(key)) continue;
            key = SymbolUtils.replaceFirstNonLetterChar(key);
            String value = String.valueOf(entry.getValue());
            symbolSet.add(key, value);
        }
    }

    private static ISymbolSet createSymbolDefinitionSet(String name, HashMap<String, String> symbols) {
        SymbolSet definitionSet = new SymbolSet();
        definitionSet.setName(name);
        definitionSet.add(name);
        for (String key : symbols.keySet()) {
            try {
                String value = symbols.get(key);
                definitionSet.add(key, value);
            }
            catch (RuntimeException e) {
                MTJLogger.log(4, e);
            }
        }
        return definitionSet;
    }

    private static void copyCapabilities(HashMap<String, String> capabilities, HashMap<String, String> parentCapabilities) {
        for (String capability : parentCapabilities.keySet()) {
            SymbolUtils.copyCapability(capabilities, capability, parentCapabilities.get(capability));
        }
    }

    private static void copyCapability(HashMap<String, String> capabilities, String name, String capability) {
        String currentCapabilityValue = capabilities.get(name);
        if (currentCapabilityValue == null || currentCapabilityValue.equals("")) {
            capabilities.put(name, capability);
        } else {
            String mergedCapabilities = SymbolUtils.mergeCapabilities(currentCapabilityValue, capability);
            capabilities.put(name, mergedCapabilities);
        }
    }

    private static HashMap<String, String> getGroupCapabilities(HashMap<String, Element> groups, String name) {
        HashMap<String, String> result = new HashMap<String, String>();
        Element groupElement = groups.get(name);
        if (groupElement != null) {
            Element parent;
            String parentValue;
            NodeList nl = groupElement.getElementsByTagName("parent");
            if (nl != null && nl.getLength() > 0 && (parentValue = (parent = (Element)nl.item(0)).getTextContent()) != null && !parent.getTextContent().equals("")) {
                HashMap<String, String> parentCapabilities = SymbolUtils.getGroupCapabilities(groups, parent.getTextContent());
                SymbolUtils.copyCapabilities(result, parentCapabilities);
            }
            if ((nl = groupElement.getElementsByTagName("capability")) != null && nl.getLength() > 0) {
                int i = 0;
                while (i < nl.getLength()) {
                    Element capabilityElement = (Element)nl.item(i);
                    result.put(capabilityElement.getAttribute("name"), capabilityElement.getAttribute("value"));
                    ++i;
                }
            }
        }
        return result;
    }

    private static String mergeCapabilities(String currentCapability, String newCapability) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(currentCapability, J2MEPOLISH_CAPABILITY_SEPARATOR);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken().trim());
        }
        st = new StringTokenizer(newCapability, J2MEPOLISH_CAPABILITY_SEPARATOR);
        while (st.hasMoreTokens()) {
            String capability = st.nextToken().trim();
            if (v.indexOf(capability) != -1) continue;
            v.add(capability);
        }
        String result = "";
        int i = 0;
        while (i < v.size()) {
            if (i > 0) {
                result = result.concat(J2MEPOLISH_CAPABILITY_SEPARATOR);
            }
            result = result.concat((String)v.elementAt(i));
            ++i;
        }
        return result;
    }

    private static HashMap<String, Element> prepareGroups(Document groupsDOM) {
        HashMap<String, Element> result = new HashMap<String, Element>();
        NodeList nl = groupsDOM.getElementsByTagName("group");
        int i = 0;
        while (i < nl.getLength()) {
            Element groupElement = (Element)nl.item(i);
            String name = ((Element)groupElement.getElementsByTagName("name").item(0)).getTextContent();
            result.put(name, groupElement);
            ++i;
        }
        return result;
    }
}

