/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.util.HashMap;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.text.AbstractTextChangeListener;
import org.eclipse.mtj.internal.core.text.IDocumentKey;
import org.eclipse.mtj.internal.core.util.PropertiesUtil;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractKeyValueTextChangeListener
extends AbstractTextChangeListener {
    protected HashMap<TextEdit, String> fReadableNames = null;

    public AbstractKeyValueTextChangeListener(IDocument document, boolean generateReadableNames) {
        super(document);
        if (generateReadableNames) {
            this.fReadableNames = new HashMap();
        }
    }

    public String getReadableName(TextEdit edit) {
        if (this.fReadableNames != null && this.fReadableNames.containsKey(edit)) {
            return this.fReadableNames.get(edit);
        }
        return null;
    }

    public TextEdit[] getTextOperations() {
        if (this.operationTable.size() == 0) {
            return new TextEdit[0];
        }
        return this.operationTable.values().toArray(new TextEdit[this.operationTable.size()]);
    }

    protected void deleteKey(IDocumentKey key, String name) {
        if (key.getOffset() >= 0) {
            DeleteEdit edit = new DeleteEdit(key.getOffset(), key.getLength());
            this.operationTable.put(key, edit);
            if (this.fReadableNames != null) {
                this.fReadableNames.put((TextEdit)edit, name);
            }
        }
    }

    protected void insertKey(IDocumentKey key, String name) {
        int offset = PropertiesUtil.getInsertOffset(this.textDocument);
        InsertEdit edit = new InsertEdit(offset, key.write());
        this.operationTable.put(key, edit);
        if (this.fReadableNames != null) {
            this.fReadableNames.put((TextEdit)edit, name);
        }
    }

    protected void modifyKey(IDocumentKey key, String name) {
        if (key.getOffset() == -1) {
            this.insertKey(key, name);
        } else {
            ReplaceEdit edit = new ReplaceEdit(key.getOffset(), key.getLength(), key.write());
            this.operationTable.put(key, edit);
            if (this.fReadableNames != null) {
                this.fReadableNames.put((TextEdit)edit, name);
            }
        }
    }
}

