/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.text.DocumentHandler;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.IDocumentXMLNode;

public abstract class NodeDocumentHandler
extends DocumentHandler {
    private IDocumentNodeFactory fFactory;

    public NodeDocumentHandler(boolean reconciling, IDocumentNodeFactory factory) {
        super(reconciling);
        this.fFactory = factory;
    }

    protected abstract IDocument getDocument();

    protected IDocumentAttributeNode getDocumentAttribute(String name, String value, IDocumentElementNode parent) {
        IDocumentAttributeNode attr = parent.getDocumentAttribute(name);
        try {
            if (attr == null) {
                attr = this.fFactory.createAttribute(name, value, parent);
            } else {
                if (!name.equals(attr.getAttributeName())) {
                    attr.setAttributeName(name);
                }
                if (!value.equals(attr.getAttributeValue())) {
                    attr.setAttributeValue(value);
                }
            }
        }
        catch (CoreException coreException) {}
        return attr;
    }

    protected IDocumentElementNode getDocumentNode(String name, IDocumentElementNode parent) {
        int n;
        int n2;
        IDocumentXMLNode[] iDocumentXMLNodeArray;
        IDocumentXMLNode node = null;
        if (parent == null) {
            node = this.getRootNode();
            if (node != null) {
                node.setOffset(-1);
                node.setLength(-1);
            }
        } else {
            IDocumentElementNode[] children = parent.getChildNodes();
            iDocumentXMLNodeArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                IDocumentXMLNode element = iDocumentXMLNodeArray[n];
                if (element.getOffset() < 0) {
                    if (!name.equals(element.getXMLTagName())) break;
                    node = element;
                    break;
                }
                ++n;
            }
        }
        if (node == null) {
            return this.fFactory.createDocumentNode(name, parent);
        }
        IDocumentAttributeNode[] attrs = node.getNodeAttributes();
        iDocumentXMLNodeArray = attrs;
        n2 = attrs.length;
        n = 0;
        while (n < n2) {
            IDocumentXMLNode attr = iDocumentXMLNodeArray[n];
            attr.setNameOffset(-1);
            attr.setNameLength(-1);
            attr.setValueOffset(-1);
            attr.setValueLength(-1);
            ++n;
        }
        int i = 0;
        while (i < node.getChildNodes().length) {
            IDocumentElementNode child = node.getChildAt(i);
            child.setOffset(-1);
            child.setLength(-1);
            ++i;
        }
        if (this.isReconciling()) {
            node.removeTextNode();
            node.setIsErrorNode(false);
        }
        return node;
    }

    protected IDocumentTextNode getDocumentTextNode(String content, IDocumentElementNode parent) {
        IDocumentTextNode textNode = parent.getTextNode();
        if (textNode == null) {
            if (content.trim().length() > 0) {
                textNode = this.fFactory.createDocumentTextNode(content, parent);
            }
        } else {
            String newContent = String.valueOf(textNode.getText()) + content;
            textNode.setText(newContent);
        }
        return textNode;
    }

    protected IDocumentNodeFactory getFactory() {
        return this.fFactory;
    }

    protected abstract IDocumentElementNode getRootNode();
}

