/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.xml.sax.SAXParseException;

public class L10nMarkerManager {
    public static final String MARKER_ID = "org.eclipse.mtj.core.problem";

    private void createMarker(IFile file, int severity, String message, int line, boolean clean) throws CoreException {
        if (clean) {
            this.clearMarkers(file, 2);
        }
        IMarker marker = file.createMarker(MARKER_ID);
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("lineNumber", line);
    }

    public void createMarker(IFile file, L10nModel fModel) throws CoreException {
        if (fModel.getStatus().getException() != null) {
            this.createMarker(file, 2, fModel.getStatus().getMessage(), ((SAXParseException)fModel.getStatus().getException()).getLineNumber(), true);
        }
    }

    public void createMarker(IFile file, SAXParseException saxException) throws CoreException {
        if (saxException != null) {
            this.createMarker(file, 2, saxException.getMessage(), saxException.getLineNumber(), true);
        }
    }

    public void createMarker(IFile file, int line, String errorMessage, boolean clean) throws CoreException {
        this.createMarker(file, 2, errorMessage, line, clean);
    }

    public void clearMarkers(IFile file, int severity) throws CoreException {
        IMarker[] mark = file.findMarkers(MARKER_ID, true, 2);
        if (mark.length > 0) {
            int i = 0;
            while (i < mark.length) {
                if (mark[i].getAttribute("severity").equals(severity)) {
                    mark[i].delete();
                }
                ++i;
            }
        }
    }

    public void addWarningMarker(IFile file, int line, String errorMessage) throws CoreException {
        this.clearWarningMarkers(file);
        this.createMarker(file, 1, errorMessage, line, false);
    }

    public void clearWarningMarkers(IFile file) throws CoreException {
        this.clearMarkers(file, 1);
    }
}

