/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.internal.core.IModel;
import org.eclipse.mtj.internal.core.text.DocumentObject;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.IL10nConstants;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class L10nObject
extends DocumentObject
implements IL10nConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private IStatus status = new Status(0, "org.eclipse.mtj.core", "");

    public L10nObject(L10nModel model, String tagName) {
        super(model, tagName);
    }

    public void addChild(L10nObject child) {
        this.addChildNode((IDocumentElementNode)child, true);
    }

    public void addChild(L10nObject child, L10nObject sibling, boolean insertBefore) {
        int currentIndex = this.indexOf(sibling);
        if (!insertBefore) {
            ++currentIndex;
        }
        this.addChildNode(child, currentIndex, true);
    }

    public abstract boolean canBeParent();

    public boolean canBeRemoved() {
        if (this.getType() == 0) {
            return false;
        }
        L10nObject parent = this.getParent();
        return parent != null;
    }

    public boolean descendsFrom(L10nObject obj) {
        if (this.equals(obj)) {
            return true;
        }
        if (this.getParent() != null && obj.canBeParent()) {
            return this.getParent().descendsFrom(obj);
        }
        return false;
    }

    public List<IDocumentElementNode> getChildren() {
        ArrayList<IDocumentElementNode> list = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode[] childNodes = this.getChildNodes();
        if (childNodes.length > 0) {
            int i = 0;
            while (i < childNodes.length) {
                if (childNodes[i] instanceof L10nObject) {
                    list.add(childNodes[i]);
                }
                ++i;
            }
        }
        return list;
    }

    public L10nLocales getLocales() {
        L10nModel model = this.getModel();
        if (model != null) {
            return model.getLocales();
        }
        return null;
    }

    public L10nModel getModel() {
        IModel sharedModel = this.getSharedModel();
        if (sharedModel instanceof L10nModel) {
            return (L10nModel)sharedModel;
        }
        return null;
    }

    public abstract String getName();

    public L10nObject getNextSibling(L10nObject l10nObject) {
        return (L10nObject)this.getNextSibling(l10nObject, L10nObject.class);
    }

    public L10nObject getParent() {
        IDocumentElementNode parent = this.getParentNode();
        return parent instanceof L10nObject ? (L10nObject)parent : null;
    }

    public L10nObject getPreviousSibling(L10nObject l10nObject) {
        return (L10nObject)this.getPreviousSibling(l10nObject, L10nObject.class);
    }

    public IStatus getStatus() {
        return this.status;
    }

    public abstract int getType();

    @Override
    public boolean isLeafNode() {
        return !this.canBeParent();
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    @Override
    public abstract void validate();

    @Override
    protected String getAttributeIndent() {
        return " ";
    }
}

