/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.mtj.internal.core.util.AbstractSearchScope;

public abstract class AbstractSuperClassSearchScope
extends AbstractSearchScope {
    private IJavaSearchScope[] scopes;

    public IJavaSearchScope[] getScopes() {
        return this.scopes;
    }

    public void setScopes(IJavaSearchScope[] scopes) {
        this.scopes = scopes;
    }

    public AbstractSuperClassSearchScope() {
    }

    public AbstractSuperClassSearchScope(IJavaProject javaProject) throws JavaModelException {
    }

    public boolean encloses(String resourcePath) {
        boolean encloses = true;
        int i = 0;
        while (encloses && i < this.scopes.length) {
            encloses = this.scopes[i].encloses(resourcePath);
            ++i;
        }
        return encloses;
    }

    public boolean encloses(IJavaElement element) {
        boolean encloses = true;
        int i = 0;
        while (encloses && i < this.scopes.length) {
            encloses = this.scopes[i].encloses(element);
            ++i;
        }
        return encloses;
    }

    public IPath[] enclosingProjectsAndJars() {
        HashSet<IPath> set = new HashSet<IPath>();
        int i = 0;
        while (i < this.scopes.length) {
            IJavaSearchScope scope = this.scopes[i];
            IPath[] scopePaths = scope.enclosingProjectsAndJars();
            int j = 0;
            while (j < scopePaths.length) {
                set.add(scopePaths[j]);
                ++j;
            }
            ++i;
        }
        return set.toArray(new IPath[set.size()]);
    }

    public IJavaSearchScope[] createSearchScopes(IJavaProject javaProject, String searchClassName, String searchClassType) throws JavaModelException {
        IJavaSearchScope[] scopes = null;
        if (javaProject == null || !javaProject.exists()) {
            IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
            scopes = new IJavaSearchScope[]{searchScope};
        } else {
            ArrayList<IPackageFragmentRoot> roots = new ArrayList<IPackageFragmentRoot>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    roots.add(root);
                }
                ++n2;
            }
            IJavaElement[] elements = roots.toArray(new IJavaElement[roots.size()]);
            IType type = javaProject.findType(searchClassType);
            scopes = type != null ? new IJavaSearchScope[]{SearchEngine.createHierarchyScope((IType)type), SearchEngine.createJavaSearchScope((IJavaElement[])elements), new MidletMidletExclusionScope(searchClassName)} : new IJavaSearchScope[]{};
        }
        return scopes;
    }

    private static class MidletMidletExclusionScope
    extends AbstractSearchScope {
        String searchClassName;

        public MidletMidletExclusionScope(String searchClassName) {
            this.searchClassName = searchClassName;
        }

        public boolean encloses(String resourcePath) {
            boolean excluded = resourcePath.endsWith("java/lang/Object.class") || resourcePath.endsWith(this.searchClassName);
            return !excluded;
        }

        public boolean encloses(IJavaElement element) {
            return true;
        }

        public IPath[] enclosingProjectsAndJars() {
            return new IPath[0];
        }
    }
}

