/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.util.IClasspathChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class ClasspathChangeMonitor
implements IResourceChangeListener {
    private static ClasspathChangeMonitor instance;
    private Map<IMTJProject, List<IClasspathChangeListener>> map = new HashMap<IMTJProject, List<IClasspathChangeListener>>();

    public static ClasspathChangeMonitor getInstance() {
        if (instance == null) {
            instance = new ClasspathChangeMonitor();
        }
        return instance;
    }

    private ClasspathChangeMonitor() {
    }

    public void addClasspathChangeListener(IMTJProject project, IClasspathChangeListener classpathChangeListener) {
        List<IClasspathChangeListener> listeners = this.map.get(project);
        if (listeners == null) {
            listeners = new ArrayList<IClasspathChangeListener>();
            this.map.put(project, listeners);
        }
        listeners.add(classpathChangeListener);
    }

    public void removeClasspathChangeListener(IMTJProject project, IClasspathChangeListener classpathChangeListener) {
        List<IClasspathChangeListener> listeners = this.map.get(project);
        if (listeners != null) {
            listeners.remove(classpathChangeListener);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        ClassPathVisitor visitor = new ClassPathVisitor();
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
    }

    class ClassPathVisitor
    implements IResourceDeltaVisitor {
        ClassPathVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean result = true;
            IResource resource = delta.getResource();
            try {
                IProject project;
                if (resource.getProjectRelativePath().toString().equals(".classpath") && delta.getKind() == 4 && (project = resource.getProject()) != null && project.hasNature("org.eclipse.mtj.core.nature")) {
                    IMTJProject mtjProject = MTJCore.geMTJProject(project);
                    List list = (List)ClasspathChangeMonitor.this.map.get(mtjProject);
                    if (list != null) {
                        for (IClasspathChangeListener iClasspathChangeListener : list) {
                            iClasspathChangeListener.classpathChanged();
                        }
                    }
                    result = false;
                }
            }
            catch (CoreException e) {
                MTJLogger.log(4, e);
            }
            return result;
        }
    }
}

