/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class EnvironmentVariables {
    private Properties variables = new Properties();
    private Map<String, String> nameMap = new HashMap<String, String>();

    public EnvironmentVariables() throws IOException {
        this.retrieveEnvironmentVariables();
    }

    public boolean containsVariable(String name) {
        return this.getVariable(name) != null;
    }

    public String[] convertToStrings() {
        String[] strings = new String[this.variables.size()];
        int index = 0;
        for (Map.Entry<Object, Object> entry : this.variables.entrySet()) {
            strings[index++] = entry.getKey() + "=" + entry.getValue();
        }
        return strings;
    }

    public String getVariable(String name) {
        String caseSpecificName = this.nameMap.get(name.toUpperCase());
        return caseSpecificName == null ? null : (String)this.variables.get(caseSpecificName);
    }

    public void setVariable(String name, String value) {
        String caseSpecificName = this.nameMap.get(name.toUpperCase());
        if (caseSpecificName == null) {
            caseSpecificName = name;
            this.nameMap.put(caseSpecificName, caseSpecificName);
        }
        this.variables.setProperty(caseSpecificName, value);
    }

    private void retrieveEnvironmentVariables() throws IOException {
        String envVarsCommand = this.getEnvironmentVariablesCommand();
        Process process = Runtime.getRuntime().exec(envVarsCommand);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                int equalsIndex = line.indexOf(61);
                if (equalsIndex == -1) continue;
                String key = line.substring(0, equalsIndex);
                String value = line.substring(equalsIndex + 1);
                this.variables.setProperty(key, value);
                this.nameMap.put(key.toUpperCase(), key);
            }
        }
        finally {
            br.close();
        }
    }

    private String getEnvironmentVariablesCommand() {
        String command = null;
        command = Platform.getOS().equals("win32") ? "cmd.exe /c set" : "env";
        return command;
    }
}

