/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.core.util.MTJHTMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJTextHelper {
    public static final String F_DOTS = "...";

    public static boolean isDefined(String text) {
        return text != null && text.length() != 0;
    }

    public static boolean isDefinedAfterTrim(String text) {
        if (text == null) {
            return false;
        }
        String trimmedText = text.trim();
        return trimmedText.length() != 0;
    }

    public static String translateReadText(String text) {
        if (text == null) {
            return "";
        }
        String result = "";
        String inputText = text.trim();
        int length = inputText.length();
        int previousChar = 32;
        StringBuffer buffer = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            int currentChar = inputText.charAt(i);
            if (currentChar == 13 || currentChar == 10 || currentChar == 9) {
                currentChar = 32;
            }
            if (currentChar == 32) {
                if (previousChar != 32) {
                    buffer.append((char)currentChar);
                    previousChar = currentChar;
                }
            } else {
                buffer.append((char)currentChar);
                previousChar = currentChar;
            }
            ++i;
        }
        result = buffer.toString();
        if (MTJHTMLHelper.isAllWhitespace(result)) {
            return "";
        }
        return result;
    }

    public static String translateWriteText(String text, HashMap<Character, String> substituteChars) {
        return MTJTextHelper.translateWriteText(text, null, substituteChars);
    }

    public static String translateWriteText(String text, HashSet<String> tagExceptions, HashMap<Character, String> substituteChars) {
        if (text == null) {
            return "";
        }
        boolean processTagExceptions = false;
        int scanLimit = 0;
        if (tagExceptions != null && !tagExceptions.isEmpty()) {
            processTagExceptions = true;
            scanLimit = MTJTextHelper.determineMaxLength(tagExceptions);
        }
        boolean processSubstituteChars = false;
        if (substituteChars != null && !substituteChars.isEmpty()) {
            processSubstituteChars = true;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        IntegerPointer index = new IntegerPointer(0);
        while (index.getInteger() < text.length()) {
            char currentChar = text.charAt(index.getInteger());
            boolean processed = false;
            if (!processed && processTagExceptions) {
                processed = MTJTextHelper.processTagExceptions(currentChar, substituteChars, tagExceptions, buffer, scanLimit, text, index);
            }
            if (!processed && processSubstituteChars) {
                processed = MTJTextHelper.processSubstituteChars(currentChar, substituteChars, buffer);
            }
            if (!processed) {
                buffer.append(currentChar);
            }
            index.increment();
        }
        return buffer.toString();
    }

    public static String truncateAndTrailOffText(String text, int limit) {
        String trimmed = text.trim();
        int dotsLength = F_DOTS.length();
        int trimmedLength = trimmed.length();
        int limitWithDots = limit - dotsLength;
        if (limit >= trimmedLength) {
            return trimmed;
        }
        if (limit <= dotsLength) {
            return "";
        }
        return String.valueOf(trimmed.substring(0, limitWithDots)) + F_DOTS;
    }

    private static int determineMaxLength(HashSet<String> set) {
        Iterator<String> iterator = set.iterator();
        int maxLength = -1;
        while (iterator.hasNext()) {
            String object = iterator.next();
            if (object.length() <= maxLength) continue;
            maxLength = object.length();
        }
        return maxLength;
    }

    private static String getTagName(String buffer) {
        StringBuffer tagName = new StringBuffer();
        int i = 0;
        while (i < buffer.length()) {
            char character = buffer.charAt(i);
            if (Character.isWhitespace(character)) break;
            tagName.append(character);
            ++i;
        }
        return tagName.toString();
    }

    private static boolean isValidTagAttributeList(String text) {
        String patternString = "^([\\s]+[A-Za-z0-9_:\\-\\.]+[\\s]?=[\\s]?\".+?\")*[\\s]*[/]?$";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    private static boolean isValidTagException(HashSet<String> tagExceptions, String buffer) {
        String tagName = MTJTextHelper.getTagName(buffer);
        return tagExceptions.contains(tagName);
    }

    private static boolean processSubstituteChars(char currentChar, HashMap<Character, String> substituteChars, StringBuffer buffer) {
        Character character = new Character(currentChar);
        if (substituteChars.containsKey(character)) {
            String value = substituteChars.get(character);
            if (MTJTextHelper.isDefined(value)) {
                buffer.append(value);
            }
            return true;
        }
        return false;
    }

    private static void processTagExceptionCharacters(HashMap<Character, String> substituteChars, StringBuffer buffer, String text) {
        String tagName = MTJTextHelper.getTagName(text);
        boolean trailingSlash = text.endsWith("/");
        String attributeList = text.substring(tagName.length());
        if (!MTJTextHelper.isValidTagAttributeList(attributeList)) {
            buffer.append('<');
            buffer.append(tagName);
            if (trailingSlash) {
                buffer.append('/');
            }
            buffer.append('>');
            return;
        }
        if (attributeList.length() == 0) {
            buffer.append('<');
            buffer.append(tagName);
            buffer.append('>');
            return;
        }
        boolean inQuote = false;
        buffer.append('<');
        int i = 0;
        while (i < text.length()) {
            boolean onQuote;
            boolean processed = false;
            char currentChar = text.charAt(i);
            boolean bl = onQuote = currentChar == '\"';
            if (onQuote) {
                inQuote = !inQuote;
            }
            if (inQuote && !onQuote) {
                processed = MTJTextHelper.processSubstituteChars(currentChar, substituteChars, buffer);
            }
            if (!processed) {
                buffer.append(currentChar);
            }
            ++i;
        }
        buffer.append('>');
    }

    private static boolean processTagExceptions(char currentChar, HashMap<Character, String> substituteChars, HashSet<String> tagExceptions, StringBuffer buffer, int scanLimit, String text, IntegerPointer index) {
        if (currentChar == '<') {
            int limit = text.length();
            StringBuffer parsedText = new StringBuffer();
            int j = index.getInteger() + 1;
            while (j < limit) {
                char futureChar = text.charAt(j);
                if (futureChar == '>') {
                    String futureBuffer = parsedText.toString();
                    if (MTJTextHelper.isValidTagException(tagExceptions, futureBuffer)) {
                        MTJTextHelper.processTagExceptionCharacters(substituteChars, buffer, futureBuffer);
                        index.setInteger(j);
                        return true;
                    }
                    return false;
                }
                parsedText.append(futureChar);
                ++j;
            }
        }
        return false;
    }

    private static class IntegerPointer {
        private int fInteger;

        public IntegerPointer(int integer) {
            this.fInteger = integer;
        }

        public int getInteger() {
            return this.fInteger;
        }

        public void increment() {
            ++this.fInteger;
        }

        public void setInteger(int integer) {
            this.fInteger = integer;
        }
    }
}

