/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.me4se;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class ME4SEDevice
extends JavaEmulatorDevice {
    private File jarFile;

    public File getJarFile() {
        return this.jarFile;
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        if (launchEnvironment.getProject() instanceof IMidletSuiteProject) {
            IMidletSuiteProject midletSuite = (IMidletSuiteProject)launchEnvironment.getProject();
            ILaunchConfiguration launchConfiguration = launchEnvironment.getLaunchConfiguration();
            boolean launchFromJAD = this.shouldDirectLaunchJAD(launchConfiguration);
            File tempDeployed = this.copyForLaunch(midletSuite, monitor, launchFromJAD);
            executionProperties.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.getJavaExecutable().toString());
            executionProperties.put("me4sejar", this.jarFile.toString());
            executionProperties.put(LaunchTemplateProperties.CLASSPATH.toString(), this.getProjectClasspathString((IMTJProject)midletSuite, tempDeployed, monitor));
            if (launchEnvironment.isDebugLaunch()) {
                executionProperties.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
            }
            String extraArguments = launchConfiguration.getAttribute("mtj.launch_params", "");
            executionProperties.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), extraArguments);
            if (this.shouldDirectLaunchJAD(launchConfiguration)) {
                executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(launchConfiguration));
            } else {
                File jadFile = this.getJadForLaunch(midletSuite, tempDeployed, monitor);
                if (jadFile.exists()) {
                    executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), jadFile.toString());
                }
            }
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, executionProperties);
    }

    public File getWorkingDirectory() {
        return null;
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.loadUsing(persistenceProvider);
        String jarFileName = persistenceProvider.loadString("jarFile");
        this.jarFile = new File(jarFileName);
    }

    public void setJarFile(File jar) {
        this.jarFile = jar;
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.storeUsing(persistenceProvider);
        persistenceProvider.storeString("jarFile", this.jarFile.toString());
    }

    protected String getProjectClasspathString(IMTJProject midletSuite, File temporaryDirectory, IProgressMonitor monitor) throws CoreException {
        StringBuffer sb = new StringBuffer(super.getProjectClasspathString(midletSuite, temporaryDirectory, monitor));
        sb.append(File.pathSeparatorChar);
        sb.append(this.jarFile);
        return sb.toString();
    }
}

