/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.motorola;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class MotorolaDevice
extends AbstractMIDPDevice {
    private static final String PROPERTIES_FILE = "propertiesFile";
    private File propertiesFile;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        if (launchEnvironment.getProject() instanceof IMidletSuiteProject) {
            File jadFile;
            boolean shouldDirectLaunchJAD;
            IMidletSuiteProject midletSuite = (IMidletSuiteProject)launchEnvironment.getProject();
            ILaunchConfiguration launchConfiguration = launchEnvironment.getLaunchConfiguration();
            boolean launchFromJAD = this.shouldDirectLaunchJAD(launchConfiguration);
            File tempDeployed = this.copyForLaunch(midletSuite, monitor, launchFromJAD);
            executionProperties.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.executable.getPath());
            executionProperties.put(LaunchTemplateProperties.DEVICE.toString(), this.getName());
            executionProperties.put("devicePropsFile", this.propertiesFile.getPath());
            if (launchEnvironment.isDebugLaunch()) {
                executionProperties.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
            }
            if (!(shouldDirectLaunchJAD = this.shouldDirectLaunchJAD(launchConfiguration))) {
                String classpathString = this.getProjectClasspathString((IMTJProject)midletSuite, tempDeployed, monitor);
                executionProperties.put(LaunchTemplateProperties.CLASSPATH.toString(), classpathString);
            }
            this.addLaunchConfigurationValue(executionProperties, LaunchTemplateProperties.VERBOSE.toString(), launchConfiguration, "mtj.verbosity_options");
            this.addLaunchConfigurationValue(executionProperties, LaunchTemplateProperties.HEAPSIZE.toString(), launchConfiguration, "mtj.heap_size");
            if (shouldDirectLaunchJAD) {
                executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(launchConfiguration));
            } else if (!this.shouldDoOTA(launchConfiguration) && (jadFile = this.getJadForLaunch(midletSuite, tempDeployed, monitor)).exists()) {
                executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), jadFile.toString());
            }
            String extraArguments = launchConfiguration.getAttribute("mtj.launch_params", "");
            executionProperties.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), extraArguments);
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, executionProperties);
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.loadUsing(persistenceProvider);
        this.propertiesFile = new File(persistenceProvider.loadString(PROPERTIES_FILE));
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.storeUsing(persistenceProvider);
        persistenceProvider.storeString(PROPERTIES_FILE, this.propertiesFile.toString());
    }

    public File getWorkingDirectory() {
        return null;
    }
}

