/**
 * Copyright (c) 2008 Motorola.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     David Marques (Motorola) - Initial version
 *     David Arag�o  (Motorola) - Added method to add  JMUnit for CLDC 1.1 library
 *     
 * @since 0.9.1
 */
package org.eclipse.mtj.internal.jmunit.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.mtj.core.project.MTJNature;
import org.eclipse.mtj.internal.core.IMTJCoreConstants;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.actions.AbstractJavaProjectAction;

/**
 * EnableJMUnitAction Class adds the JMUnit Nature from a project.
 * 
 * @author David Marques
 */
public class EnableJMUnitAction extends AbstractJavaProjectAction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if ((selection != null) && !selection.isEmpty()) {
			IJavaProject javaProject = getJavaProject(selection
					.getFirstElement());
			if (javaProject == null) {
				return;
			}
			try {
				MTJNature.addNatureToProject(javaProject.getProject(),
						IMTJCoreConstants.JMUNIT_NATURE_ID,
						new NullProgressMonitor());

				ExternalLibraryManager.getInstance().addLibraryToMidletProject(
						javaProject.getProject(), "JMUnit for CLDC 1.1"); //$NON-NLS-1$
			} catch (CoreException e) {
				MTJLogger.log(IStatus.ERROR, e);
			}
		}
	}

}
